/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.security;

import io.grpc.Context;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class MDCHeadersServerInterceptor
implements ServerInterceptor {
    public static final Context.Key<String> HEADERS_TO_FORWARD_CONTEXT = Context.key((String)"headers");
    public static final Metadata.Key<String> HEADERS_TO_FORWARD = Metadata.Key.of((String)"headers", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        String headersValue = (String)metadata.get(HEADERS_TO_FORWARD);
        if (StringUtils.isEmpty((CharSequence)headersValue)) {
            return serverCallHandler.startCall(serverCall, metadata);
        }
        Context context = Context.current().withValue(HEADERS_TO_FORWARD_CONTEXT, (Object)headersValue);
        Context previous = context.attach();
        try {
            HeadersToForwardServerCallListener headersToForwardServerCallListener = new HeadersToForwardServerCallListener(serverCallHandler.startCall(serverCall, metadata), headersValue, context);
            return headersToForwardServerCallListener;
        }
        finally {
            context.detach(previous);
        }
    }

    private static class HeadersToForwardServerCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private final String headers;
        private final Context context;

        protected HeadersToForwardServerCallListener(ServerCall.Listener<ReqT> delegate, String headers, Context context) {
            super(delegate);
            this.headers = headers;
            this.context = context;
        }

        public void onMessage(ReqT message) {
            Context previous = this.context.attach();
            try {
                MDC.put((String)"headers", (String)this.headers);
                super.onMessage(message);
            }
            finally {
                this.context.detach(previous);
                MDC.remove((String)"headers");
            }
        }

        public void onHalfClose() {
            Context previous = this.context.attach();
            try {
                MDC.put((String)"headers", (String)this.headers);
                super.onHalfClose();
            }
            finally {
                this.context.detach(previous);
                MDC.remove((String)"headers");
            }
        }

        public void onCancel() {
            Context previous = this.context.attach();
            try {
                MDC.put((String)"headers", (String)this.headers);
                super.onCancel();
            }
            finally {
                this.context.detach(previous);
                MDC.remove((String)"headers");
            }
        }

        public void onComplete() {
            Context previous = this.context.attach();
            try {
                MDC.put((String)"headers", (String)this.headers);
                super.onComplete();
            }
            finally {
                this.context.detach(previous);
                MDC.remove((String)"headers");
            }
        }

        public void onReady() {
            Context previous = this.context.attach();
            try {
                MDC.put((String)"headers", (String)this.headers);
                super.onReady();
            }
            finally {
                this.context.detach(previous);
                MDC.remove((String)"headers");
            }
        }
    }
}

