/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.security;

import com.ontotext.graphdb.raft.security.MDCHeadersServerInterceptor;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.CompositeCallCredentials;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class MDCHeadersClientInterceptor
implements ClientInterceptor {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel channel) {
        String headersFromMDC = MDC.get((String)"headers");
        if (StringUtils.isEmpty((CharSequence)headersFromMDC)) {
            return channel.newCall(method, callOptions);
        }
        CallCredentials credentials = callOptions.getCredentials();
        credentials = credentials == null ? new MDCHeadersCallCredentials(headersFromMDC) : new CompositeCallCredentials(credentials, (CallCredentials)new MDCHeadersCallCredentials(headersFromMDC));
        return channel.newCall(method, callOptions.withCallCredentials(credentials));
    }

    private static class MDCHeadersCallCredentials
    extends CallCredentials {
        private final String headersFromMDC;

        public MDCHeadersCallCredentials(String headersFromMDC) {
            this.headersFromMDC = headersFromMDC;
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
            Metadata metadata = new Metadata();
            metadata.put(MDCHeadersServerInterceptor.HEADERS_TO_FORWARD, (Object)this.headersFromMDC);
            applier.apply(metadata);
        }

        public void thisUsesUnstableApi() {
        }
    }
}

