/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.NodeState;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.grpc.PullEntry;
import com.ontotext.graphdb.raft.grpc.PullRequest;
import com.ontotext.graphdb.raft.grpc.ReportingIterator;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.raft.util.RaftUtil;
import java.io.OutputStream;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullPrimaryUpdateTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PullPrimaryUpdateTask.class);
    private final RaftTaskController controller;
    private final LongSupplier replicateBatchHook;

    public PullPrimaryUpdateTask(RaftTaskController controller, LongSupplier replicateBatchHook) {
        this.controller = controller;
        this.replicateBatchHook = replicateBatchHook;
    }

    @Override
    public void run() {
        RpcNodeClient leader = this.getPrimaryLeader();
        TransactionLog log = this.controller.getTransactionLog();
        boolean hasData = false;
        long primaryIndex = this.controller.getGroup().getPrimaryIndex();
        OutputStream stream = null;
        this.validateState();
        try {
            ReportingIterator<PullEntry> iter = leader.pullTransactions(PullRequest.newBuilder().setTag(this.controller.getGroup().getSecondaryTag()).setAddress(this.controller.getCurrentAddress()).setLastIndex(primaryIndex).build());
            try {
                while (iter.hasNext()) {
                    PullEntry data = iter.next();
                    if (!data.getHasData()) continue;
                    if (!hasData) {
                        stream = log.beginTransactionRecord("SECONDARY", this.controller.getGroup().getRecoveryFlag());
                        hasData = true;
                        stream.write(3);
                    }
                    stream.write(data.getData().toByteArray());
                }
                this.validateState();
            }
            catch (Exception e) {
                if (hasData) {
                    log.rollbackTransactionRecord("SECONDARY");
                }
                throw e;
            }
            if (hasData) {
                long index = this.replicateBatchHook.getAsLong();
                if (index < 1L) {
                    throw new RaftException("Failed batch update replication");
                }
            } else {
                logger.debug("No updates fetched from primary cluster with last log index {}", (Object)primaryIndex);
            }
        }
        catch (Exception e) {
            logger.error("Failed to pull updates from primary cluster due to: ", (Throwable)e);
            this.controller.getGroup().resetPrimaryLeader();
        }
    }

    private void validateState() {
        if (this.controller.getNodeState() != NodeState.LEADER) {
            throw new RaftException("Node is not leader");
        }
        if (!this.controller.getGroup().isSecondary()) {
            throw new RaftException("Node is not in secondary cluster");
        }
        if (this.controller.getGroup().isRecovering()) {
            throw new RaftException("Node is recovering");
        }
    }

    private RpcNodeClient getPrimaryLeader() {
        RpcNodeClient leader = this.controller.getGroup().getPrimaryLeader();
        if (leader == null) {
            logger.info("Finding primary cluster leader");
            leader = RaftUtil.getPrimaryLeader(this.controller);
            if (this.controller.getGroup().setPrimaryLeader(leader)) {
                logger.info("Successfully found primary cluster leader and set to {}", (Object)leader.getAddress());
            }
        }
        return leader;
    }
}

