/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.ReportingIterator;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.grpc.SnapshotData;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.raft.util.RaftUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullPrimarySnapshotTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PullPrimarySnapshotTask.class);
    private final RaftTaskController controller;
    private final RpcNodeClient primaryLeader;
    private final String tag;

    public PullPrimarySnapshotTask(RaftTaskController controller, NodeInfo primaryNode, String tag) {
        this.controller = controller;
        this.tag = tag;
        this.primaryLeader = new RpcNodeClient(primaryNode.getRpcAddress(), 0L, controller.getCurrentAddress(), controller.getMessageSizeBytes());
    }

    @Override
    public void run() {
        TransactionLog log = this.controller.getTransactionLog();
        DataOutputStream stream = new DataOutputStream(log.beginTransactionRecord("SECONDARY", this.controller.getGroup().getRecoveryFlag()));
        try {
            ReportingIterator<SnapshotData> iter = this.primaryLeader.requestSnapshot(0L, this.tag);
            SnapshotData data = iter.next();
            SnapshotData.NullableSnapshotMeta.KindCase kindCase = data.getMeta().getKindCase();
            if (kindCase != SnapshotData.NullableSnapshotMeta.KindCase.METADATA) {
                throw new RaftException("unable to apply snapshot for recovery as metadata is missing");
            }
            stream.write(1);
            this.writeMetadata(data.getMeta().getMetadata(), stream);
            stream.write(data.getData().toByteArray());
            while (iter.hasNext()) {
                stream.write(iter.next().getData().toByteArray());
            }
            stream.flush();
        }
        catch (Exception e) {
            logger.error("Failed to pull updates from primary cluster due to: ", (Throwable)e);
            log.rollbackTransactionRecord("SECONDARY");
            if (e instanceof RaftException) {
                throw (RaftException)((Object)e);
            }
            throw new RaftException(e);
        }
        finally {
            this.primaryLeader.close();
        }
    }

    private void writeMetadata(SnapshotData.SnapshotMeta meta, DataOutputStream stream) throws IOException {
        stream.write(RaftUtil.serializeString(this.tag));
        long logIndex = meta.getMatchIndex();
        Map<String, String> primaryGroup = meta.getGroupIdsMap();
        stream.writeLong(logIndex);
        stream.writeInt(primaryGroup.size());
        for (Map.Entry<String, String> entry : primaryGroup.entrySet()) {
            stream.write(RaftUtil.serializeString(entry.getKey()));
            stream.write(RaftUtil.serializeString(entry.getValue()));
        }
        Map<String, Integer> channelMap = meta.getChannelMappingMap();
        stream.writeInt(channelMap.size());
        for (Map.Entry<String, Integer> entry : channelMap.entrySet()) {
            stream.write(RaftUtil.serializeString(entry.getKey()));
            stream.writeInt(entry.getValue());
        }
    }
}

