/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;

public class SemaphoreLock
implements Lock {
    private final Semaphore semaphore;

    public SemaphoreLock() {
        this(true);
    }

    public SemaphoreLock(boolean fair) {
        this.semaphore = new Semaphore(1, fair);
    }

    @Override
    public void lock() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.semaphore.acquire();
    }

    @Override
    public boolean tryLock() {
        return this.semaphore.tryAcquire();
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit timeUnit) {
        try {
            return this.semaphore.tryAcquire(time, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    public boolean hasQueuedThreads() {
        return this.semaphore.hasQueuedThreads();
    }

    @Override
    public void unlock() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits != 0) {
            throw new IllegalMonitorStateException("Lock already unlocked!");
        }
        this.semaphore.release();
    }

    @Override
    @NotNull
    public Condition newCondition() {
        throw new UnsupportedOperationException("Node Lock does not support this");
    }
}

