/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.concurrent;

import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.concurrent.QuorumStateException;
import java.util.concurrent.Future;

public class QuorumWrapper
implements Quorum {
    private volatile Quorum delegateQuorum;

    public QuorumWrapper(Quorum delegateQuorum) {
        this.delegateQuorum = delegateQuorum;
    }

    public void removeDelegate() {
        this.delegateQuorum = null;
    }

    public Quorum getDelegate() {
        return this.delegateQuorum;
    }

    @Override
    public void clear() {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.clear();
        }
    }

    @Override
    public void setTotal(boolean total) {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.setTotal(total);
        }
    }

    @Override
    public boolean getTotal() {
        Quorum quorum = this.delegateQuorum;
        if (quorum == null) {
            throw new QuorumStateException("Delegate quorum has already been cleared");
        }
        return quorum.getTotal();
    }

    @Override
    public void addTask(Future<?> task) {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.addTask(task);
        }
    }

    @Override
    public void await() {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.await();
        }
    }

    @Override
    public void awaitStart() {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.awaitStart();
        }
    }

    @Override
    public void awaitAll() {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.awaitAll();
        }
    }

    @Override
    public void increment(boolean success) {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.increment(success);
        }
    }

    @Override
    public void incrementStart() {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.incrementStart();
        }
    }

    @Override
    public void fail() {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.fail();
        }
    }

    @Override
    public Quorum.State getState() {
        Quorum quorum = this.delegateQuorum;
        if (quorum == null) {
            throw new QuorumStateException("Delegate quorum has already been cleared");
        }
        return quorum.getState();
    }

    @Override
    public void setSize(int newSize) {
        Quorum quorum = this.delegateQuorum;
        if (quorum != null) {
            quorum.setSize(newSize);
        }
    }
}

