/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node;

import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.concurrent.FutureQuorum;
import com.ontotext.graphdb.raft.node.concurrent.QuorumWrapper;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class QuorumCache {
    private final Queue<Quorum> quorums;

    public QuorumCache(int capacity, int initSize) {
        this.quorums = new LinkedBlockingQueue<Quorum>(capacity);
        for (int i = 0; i < capacity; ++i) {
            this.quorums.add(new FutureQuorum(initSize));
        }
    }

    public Quorum fetchQuorum(int size) {
        Quorum quorum = this.quorums.poll();
        if (quorum == null) {
            quorum = new FutureQuorum(size);
        } else {
            quorum.setSize(size);
        }
        return new QuorumWrapper(quorum);
    }

    public Quorum fetchTotalQuorum(int size) {
        Quorum quorum = this.quorums.poll();
        if (quorum == null) {
            quorum = new FutureQuorum(size);
        } else {
            quorum.setSize(size);
        }
        quorum.setTotal(true);
        return new QuorumWrapper(quorum);
    }

    public void releaseQuorum(Quorum quorum) {
        quorum.setTotal(false);
        quorum.clear();
        if (quorum instanceof QuorumWrapper) {
            QuorumWrapper wrapper = (QuorumWrapper)quorum;
            Quorum delegate = wrapper.getDelegate();
            if (delegate != null) {
                this.quorums.offer(delegate);
            }
            wrapper.removeDelegate();
        } else {
            this.quorums.offer(quorum);
        }
    }
}

