/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.grpc;

import com.ontotext.graphdb.raft.grpc.NodeException;
import java.util.Iterator;
import java.util.function.BiConsumer;

public class ReportingIterator<X>
implements Iterator<X> {
    private final Iterator<X> nestedIterator;
    private final BiConsumer<String, Throwable> errorConsumer;

    public ReportingIterator(Iterator<X> nestedIterator, BiConsumer<String, Throwable> errorConsumer) {
        this.nestedIterator = nestedIterator;
        this.errorConsumer = errorConsumer;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.nestedIterator.hasNext();
        }
        catch (Exception e) {
            throw new NodeException(e);
        }
    }

    @Override
    public X next() {
        try {
            return this.nestedIterator.next();
        }
        catch (Exception e) {
            throw new NodeException(e);
        }
    }

    public void reportError(String message, Throwable t) {
        this.errorConsumer.accept(message, t);
    }
}

