/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.grpc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphdb.raft.grpc.NodeException;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.security.MDCHeadersClientInterceptor;
import com.ontotext.graphdb.raft.security.RequestSignerInterceptor;
import com.ontotext.graphdb.raft.security.SecurityConfig;
import com.ontotext.graphdb.raft.security.SecurityUtil;
import common.GraphDBMDCExecutorBuilder;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcClient
implements Closeable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String clientAddress;
    protected final int messageSizeBytes;
    protected final int clientId;
    protected final AtomicBoolean isInit;
    protected final AtomicBoolean isShutDown;
    protected ExecutorService clientExecutor;
    protected ManagedChannel mainChannel;

    public AbstractRpcClient(String clientAddress, int messageSizeBytes) {
        this.clientAddress = clientAddress;
        this.clientId = System.identityHashCode(clientAddress.intern());
        this.messageSizeBytes = messageSizeBytes;
        this.isInit = new AtomicBoolean(false);
        this.isShutDown = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (!this.isInit.get()) {
            if (this.isShutDown.get()) {
                throw new IllegalStateException("RPC client already shut down");
            }
            AtomicBoolean atomicBoolean = this.isInit;
            synchronized (atomicBoolean) {
                if (this.isInit.get()) {
                    return;
                }
                this.logger.debug("Initialized channel to {} for client '{}'", (Object)this.clientAddress, (Object)System.identityHashCode(this));
                try {
                    this.clientExecutor = this.buildExecutor();
                    this.mainChannel = this.buildChannel(this.clientExecutor);
                    this.initStubs();
                }
                catch (Exception e) {
                    this.logger.error("Error occurred during rpc client initialization for node {}", (Object)this.getAddress());
                    this.clientExecutor.shutdown();
                    this.mainChannel = null;
                    this.isInit.set(false);
                    throw new RaftRpcConnectionException(e);
                }
                this.isInit.set(true);
            }
        }
    }

    public abstract void initStubs();

    public void shutdown() {
        this.isShutDown.set(true);
        if (this.isInit.compareAndSet(true, false)) {
            this.shutdownChannel(this.mainChannel);
            this.clientExecutor.shutdown();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void shutdownChannel(ManagedChannel channel) {
        if (channel != null && !channel.isShutdown()) {
            this.logger.debug("Shutting down client {} to {}", (Object)System.identityHashCode(this), (Object)this.clientAddress);
            try {
                channel.shutdown();
                channel.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public int getMessageSizeBytes() {
        return this.messageSizeBytes;
    }

    public int getClientId() {
        return this.clientId;
    }

    public String getAddress() {
        return this.clientAddress;
    }

    protected ManagedChannel buildChannel(ExecutorService executorService) {
        ChannelCredentials channelCredentials = SecurityUtil.createChannelCredentials((SecurityConfig)SecurityConfig.INSTANCE);
        ManagedChannelBuilder builder = Grpc.newChannelBuilder((String)this.clientAddress, (ChannelCredentials)channelCredentials).intercept(new ClientInterceptor[]{new RequestSignerInterceptor(this.clientAddress), new MDCHeadersClientInterceptor()});
        if (executorService != null) {
            builder.executor((Executor)executorService).offloadExecutor((Executor)executorService);
        }
        return builder.build();
    }

    protected ExecutorService buildExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.clientAddress + "-rpc-client-" + System.identityHashCode(this) + "-%d").build();
        ThreadPoolExecutor service = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        service.setRejectedExecutionHandler((r, executor) -> {
            if (!executor.isShutdown()) {
                throw new RejectedExecutionException("Task " + String.valueOf(r) + " rejected from " + String.valueOf(executor));
            }
            this.logger.warn("Rejecting task execution due to executor being shut down");
        });
        return GraphDBMDCExecutorBuilder.build((ExecutorService)service);
    }

    protected void moveChannelToIdleIfNeeded(Throwable t) {
        Status status = this.fetchStatus(t);
        if (this.isStatusUnavailable(status) && status.getDescription() != null && status.getDescription().contains("Wrong recipient.")) {
            this.logger.warn("Channel moves to idle state");
            this.mainChannel.enterIdle();
        }
    }

    private Status fetchStatus(Throwable t) {
        Status status = null;
        if (t instanceof StatusException) {
            status = ((StatusException)t).getStatus();
        } else if (t instanceof StatusRuntimeException) {
            status = ((StatusRuntimeException)t).getStatus();
        } else if (t instanceof RaftRpcConnectionException) {
            status = ((RaftRpcConnectionException)t).getStatus();
        } else if (t instanceof NodeException) {
            status = this.fetchStatus(t.getCause());
        }
        return status;
    }

    private boolean isStatusUnavailable(Status status) {
        return status != null && status.getCode().equals((Object)Status.UNAVAILABLE.getCode());
    }
}

