/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.Values;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class StructUtil {
    private StructUtil() {
    }

    public static Struct mapToStruct(Map<String, Object> map) {
        Struct.Builder builder = Struct.newBuilder();
        map.forEach((key, value) -> builder.putFields(key, StructUtil.objectToValue(value)));
        return builder.build();
    }

    public static Value objectToValue(Object value) {
        if (value instanceof Boolean) {
            return Values.of((boolean)((Boolean)value));
        }
        if (value instanceof Number) {
            return Values.of((double)((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return Values.of((String)value.toString());
        }
        if (value instanceof Collection) {
            ListValue.Builder listValues = ListValue.newBuilder();
            ((Collection)value).stream().map(StructUtil::objectToValue).forEach(arg_0 -> ((ListValue.Builder)listValues).addValues(arg_0));
            return Values.of((ListValue)listValues.build());
        }
        if (value instanceof Map) {
            return Values.of((Struct)StructUtil.mapToStruct((Map)value));
        }
        if (value != null) {
            throw new IllegalArgumentException("Non serializable " + String.valueOf(Struct.class) + " value: " + String.valueOf(value));
        }
        return Values.ofNull();
    }

    public static Map<String, Object> structToMap(Struct struct) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(struct.getFieldsCount());
        struct.getFieldsMap().forEach((key, value) -> result.put((String)key, StructUtil.valueToObject(value)));
        return result;
    }

    public static Object valueToObject(Value value) {
        if (value.hasBoolValue()) {
            return value.getBoolValue();
        }
        if (value.hasStringValue()) {
            return value.getStringValue();
        }
        if (value.hasNumberValue()) {
            return value.getNumberValue();
        }
        if (value.hasListValue()) {
            return value.getListValue().getValuesList().stream().map(StructUtil::valueToObject).collect(Collectors.toList());
        }
        if (value.hasStructValue()) {
            return StructUtil.structToMap(value.getStructValue());
        }
        if (value.hasNullValue()) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported " + String.valueOf(Value.class) + ": " + String.valueOf(value));
    }
}

