/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.postprocessor;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.MutationResponse;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.graphql.responder.validation.PostMutationContext;
import com.ontotext.graphql.responder.validation.PostMutationProcessor;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.TrackChangesLoader;
import com.ontotext.sparql.TrackChangesLoaderOptimized;
import com.ontotext.sparql.TrackChangesRemover;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchChangesPostProcessor
implements PostMutationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TrackChangesLoader changesLoader = new TrackChangesLoader();
    private final TrackChangesRemover changesRemover = new TrackChangesRemover();

    public OperationResponse process(EndpointExecutionResponse<MutationResponse> mutationResponse, UpdateExecution request, SparqlEndpoint endpoint, SparqlQueryInvoker sparqlInvoker, PostMutationContext context) {
        if (!mutationResponse.isValid() || mutationResponse.rollback() || !request.needToFetchChanges()) {
            return OperationResponse.EMPTY;
        }
        List requestIds = request.getUpdateSteps().stream().map(UpdateStep::getRequestId).distinct().collect(Collectors.toList());
        if (requestIds.isEmpty()) {
            return OperationResponse.EMPTY;
        }
        SomlSchema schema = request.getSchema();
        String requestId = request.getRequestId();
        if (!request.isSilent()) {
            LOGGER.info("Loading mutation '{}' changes for {} sub updates: {}", new Object[]{requestId, requestIds.size(), requestIds});
        }
        TrackChangesLoaderOptimized.LoaderResponse loaderResponse = this.changesLoader.fetchChanges(requestId, requestIds, schema, endpoint, sparqlInvoker);
        this.consumeResult(mutationResponse, loaderResponse);
        this.changesRemover.removeChanges(requestId, requestIds, schema, endpoint, sparqlInvoker).ifPresent(mutationResponse.getErrors()::add);
        return OperationResponse.EMPTY;
    }

    private void consumeResult(EndpointExecutionResponse<MutationResponse> mutationResponse, TrackChangesLoaderOptimized.LoaderResponse loaderResponse) {
        if (loaderResponse.getResultDiff() != null) {
            ((MutationResponse)mutationResponse.getData()).getResultDiff().merge(loaderResponse.getResultDiff());
        }
        if (CollectionsUtil.isNotNullOrEmpty((Collection)loaderResponse.getErrors())) {
            mutationResponse.getErrors().addAll(loaderResponse.getErrors());
        }
    }
}

