/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.mustache;

import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.IterableCode;
import com.github.mustachejava.codes.WriteCode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

abstract class CustomCode
extends IterableCode {
    private final String code;

    CustomCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String code) {
        super(tc, df, mustache, CustomCode.extractVariableName(code, mustache, tc));
        this.code = Objects.requireNonNull(code);
    }

    public Writer execute(Writer writer, List<Object> scopes) {
        Object resolved = this.get(scopes);
        writer = this.handle(writer, this.createFunction(resolved), scopes);
        this.appendText(writer);
        return writer;
    }

    protected void tag(Writer writer, String tag) throws IOException {
        writer.write(this.tc.startChars());
        writer.write(tag);
        writer.write(this.code);
        writer.write(this.tc.endChars());
    }

    protected abstract Function<String, String> createFunction(Object var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String extractVariableName(String fn, Mustache mustache, TemplateContext tc) {
        Code[] codes = mustache.getCodes();
        if (codes == null) throw new MustacheException("Mustache function [" + fn + "] must contain one and only one identifier");
        if (codes.length != 1) {
            throw new MustacheException("Mustache function [" + fn + "] must contain one and only one identifier");
        }
        try (StringWriter capture = new StringWriter();){
            if (codes[0] instanceof WriteCode) {
                codes[0].execute((Writer)capture, Collections.emptyList());
                String string = capture.toString();
                return string;
            }
            codes[0].identity((Writer)capture);
            String string = capture.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new MustacheException("Exception while parsing mustache function [" + fn + "] at line " + tc.line(), (Throwable)ioe);
        }
    }
}

