/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLClassExpressionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectComplementOfImpl;

public class OWLClassImpl
extends OWLClassExpressionImpl
implements OWLClass,
Serializable {
    private final IRI iri;
    private final boolean isThing;
    private final boolean isNothing;

    public OWLClassImpl(IRI iri) {
        this.iri = (IRI)OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        this.isThing = this.getIRI().isThing();
        this.isNothing = this.getIRI().isNothing();
    }

    public OWLClassExpression getObjectComplementOf() {
        return new OWLObjectComplementOfImpl(this);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.isOWLThing() || this.isOWLNothing();
    }

    public boolean isOWLThing() {
        return this.isThing;
    }

    public boolean isOWLNothing() {
        return this.isNothing;
    }

    public OWLClassExpression getNNF() {
        return this;
    }

    public Set<OWLClassExpression> asConjunctSet() {
        return CollectionFactory.createSet((Object)this);
    }

    public Stream<OWLClassExpression> conjunctSet() {
        return Stream.of(this);
    }

    public boolean containsConjunct(OWLClassExpression ce) {
        return ce.equals((Object)this);
    }

    public Set<OWLClassExpression> asDisjunctSet() {
        return CollectionFactory.createSet((Object)this);
    }

    public OWLClassExpression getComplementNNF() {
        return new OWLObjectComplementOfImpl(this);
    }

    public Stream<OWLClassExpression> disjunctSet() {
        return Stream.of(this);
    }
}

