/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.util.AbstractCollector;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.ClassAxiomByClassPointer;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;

public class Internals
implements Serializable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Internals.class);
    private final AddAxiomVisitor addChangeVisitor = new AddAxiomVisitor();
    private final RemoveAxiomVisitor removeChangeVisitor = new RemoveAxiomVisitor();
    private final ReferenceChecker refChecker = new ReferenceChecker();
    private final ReferencedAxiomsCollector refAxiomsCollector = new ReferencedAxiomsCollector();
    protected transient MapPointer<OWLClassExpression, OWLClassAssertionAxiom> classAssertionAxiomsByClass = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.CLASSEXPRESSIONS, OWLClassAssertionAxiom.class);
    protected transient MapPointer<OWLAnnotationSubject, OWLAnnotationAssertionAxiom> annotationAssertionAxiomsBySubject = this.buildLazy(AxiomType.ANNOTATION_ASSERTION, InitVisitorFactory.ANNOTSUPERNAMED, OWLAnnotationAssertionAxiom.class);
    protected transient MapPointer<OWLClass, OWLSubClassOfAxiom> subClassAxiomsBySubPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUBNAMED, OWLSubClassOfAxiom.class);
    protected transient MapPointer<OWLClass, OWLSubClassOfAxiom> subClassAxiomsBySuperPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUPERNAMED, OWLSubClassOfAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLSubObjectPropertyOfAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUPERNAMED, OWLSubObjectPropertyOfAxiom.class);
    protected transient MapPointer<OWLDataPropertyExpression, OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED, OWLSubDataPropertyOfAxiom.class);
    protected transient MapPointer<OWLDataPropertyExpression, OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUPERNAMED, OWLSubDataPropertyOfAxiom.class);
    protected transient MapPointer<OWLClass, OWLClassAxiom> classAxiomsByClass = this.buildClassAxiomByClass();
    protected transient MapPointer<OWLClass, OWLEquivalentClassesAxiom> equivalentClassesAxiomsByClass = this.buildLazy(AxiomType.EQUIVALENT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS, OWLEquivalentClassesAxiom.class);
    protected transient MapPointer<OWLClass, OWLDisjointClassesAxiom> disjointClassesAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS, OWLDisjointClassesAxiom.class);
    protected transient MapPointer<OWLClass, OWLDisjointUnionAxiom> disjointUnionAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_UNION, InitVisitorFactory.CLASSCOLLECTIONS, OWLDisjointUnionAxiom.class);
    protected transient MapPointer<OWLClass, OWLHasKeyAxiom> hasKeyAxiomsByClass = this.buildLazy(AxiomType.HAS_KEY, InitVisitorFactory.CLASSSUPERNAMED, OWLHasKeyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS, OWLEquivalentObjectPropertiesAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLDisjointObjectPropertiesAxiom> disjointObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS, OWLDisjointObjectPropertiesAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLObjectPropertyDomainAxiom> objectPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_DOMAIN, InitVisitorFactory.OPSUBNAMED, OWLObjectPropertyDomainAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLObjectPropertyRangeAxiom> objectPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_RANGE, InitVisitorFactory.OPSUBNAMED, OWLObjectPropertyRangeAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLFunctionalObjectPropertyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalPropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLInverseFunctionalObjectPropertyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSymmetricObjectPropertyAxiom> symmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.SYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLSymmetricObjectPropertyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLAsymmetricObjectPropertyAxiom> asymmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLAsymmetricObjectPropertyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLReflexiveObjectPropertyAxiom> reflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.REFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLReflexiveObjectPropertyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLIrreflexiveObjectPropertyAxiom> irreflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLIrreflexiveObjectPropertyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLTransitiveObjectPropertyAxiom> transitivePropertyAxiomsByProperty = this.buildLazy(AxiomType.TRANSITIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLTransitiveObjectPropertyAxiom.class);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLInverseObjectPropertiesAxiom> inversePropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS, OWLInverseObjectPropertiesAxiom.class);
    protected transient MapPointer<OWLDataPropertyExpression, OWLEquivalentDataPropertiesAxiom> equivalentDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS, OWLEquivalentDataPropertiesAxiom.class);
    protected transient MapPointer<OWLDataPropertyExpression, OWLDisjointDataPropertiesAxiom> disjointDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS, OWLDisjointDataPropertiesAxiom.class);
    protected transient MapPointer<OWLDataPropertyExpression, OWLDataPropertyDomainAxiom> dataPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_DOMAIN, InitVisitorFactory.DPSUBNAMED, OWLDataPropertyDomainAxiom.class);
    protected transient MapPointer<OWLDataPropertyExpression, OWLDataPropertyRangeAxiom> dataPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_RANGE, InitVisitorFactory.DPSUBNAMED, OWLDataPropertyRangeAxiom.class);
    protected transient MapPointer<OWLDataPropertyExpression, OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED, OWLFunctionalDataPropertyAxiom.class);
    protected transient MapPointer<OWLIndividual, OWLClassAssertionAxiom> classAssertionAxiomsByIndividual = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLClassAssertionAxiom.class);
    protected transient MapPointer<OWLIndividual, OWLObjectPropertyAssertionAxiom> objectPropertyAssertionsByIndividual = this.buildLazy(AxiomType.OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLObjectPropertyAssertionAxiom.class);
    protected transient MapPointer<OWLIndividual, OWLDataPropertyAssertionAxiom> dataPropertyAssertionsByIndividual = this.buildLazy(AxiomType.DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLDataPropertyAssertionAxiom.class);
    protected transient MapPointer<OWLIndividual, OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLNegativeObjectPropertyAssertionAxiom.class);
    protected transient MapPointer<OWLIndividual, OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLNegativeDataPropertyAssertionAxiom.class);
    protected transient MapPointer<OWLIndividual, OWLDifferentIndividualsAxiom> differentIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.DIFFERENT_INDIVIDUALS, InitVisitorFactory.ICOLLECTIONS, OWLDifferentIndividualsAxiom.class);
    protected transient MapPointer<OWLIndividual, OWLSameIndividualAxiom> sameIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.SAME_INDIVIDUAL, InitVisitorFactory.ICOLLECTIONS, OWLSameIndividualAxiom.class);
    protected SetPointer<OWLImportsDeclaration> importsDeclarations = new SetPointer();
    protected SetPointer<OWLAnnotation> ontologyAnnotations = new SetPointer();
    protected SetPointer<OWLClassAxiom> generalClassAxioms = new SetPointer();
    protected SetPointer<OWLSubPropertyChainOfAxiom> propertyChainSubPropertyAxioms = new SetPointer();
    protected transient MapPointer<AxiomType, OWLAxiom> axiomsByType = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLClass, OWLAxiom> owlClassReferences = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLObjectProperty, OWLAxiom> owlObjectPropertyReferences = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLDataProperty, OWLAxiom> owlDataPropertyReferences = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLNamedIndividual, OWLAxiom> owlIndividualReferences = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLAnonymousIndividual, OWLAxiom> owlAnonymousIndividualReferences = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLDatatype, OWLAxiom> owlDatatypeReferences = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLAnnotationProperty, OWLAxiom> owlAnnotationPropertyReferences = this.build(OWLAxiom.class);
    protected transient MapPointer<OWLEntity, OWLDeclarationAxiom> declarationsByEntity = this.build(OWLDeclarationAxiom.class);
    @Nullable
    private List<OWLAxiom> axiomsForSerialization;

    public static <K, V extends OWLAxiom> boolean contains(MapPointer<K, V> p, K k, V v) {
        return p.contains(k, v);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.axiomsByType = this.build(OWLAxiom.class);
        this.owlClassReferences = this.build(OWLAxiom.class);
        this.owlObjectPropertyReferences = this.build(OWLAxiom.class);
        this.owlDataPropertyReferences = this.build(OWLAxiom.class);
        this.owlIndividualReferences = this.build(OWLAxiom.class);
        this.owlAnonymousIndividualReferences = this.build(OWLAxiom.class);
        this.owlDatatypeReferences = this.build(OWLAxiom.class);
        this.owlAnnotationPropertyReferences = this.build(OWLAxiom.class);
        this.declarationsByEntity = this.build(OWLDeclarationAxiom.class);
        this.classAssertionAxiomsByClass = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.CLASSEXPRESSIONS, OWLClassAssertionAxiom.class);
        this.annotationAssertionAxiomsBySubject = this.buildLazy(AxiomType.ANNOTATION_ASSERTION, InitVisitorFactory.ANNOTSUPERNAMED, OWLAnnotationAssertionAxiom.class);
        this.subClassAxiomsBySubPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUBNAMED, OWLSubClassOfAxiom.class);
        this.subClassAxiomsBySuperPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUPERNAMED, OWLSubClassOfAxiom.class);
        this.objectSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLSubObjectPropertyOfAxiom.class);
        this.objectSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUPERNAMED, OWLSubObjectPropertyOfAxiom.class);
        this.dataSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED, OWLSubDataPropertyOfAxiom.class);
        this.dataSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUPERNAMED, OWLSubDataPropertyOfAxiom.class);
        this.classAxiomsByClass = this.buildClassAxiomByClass();
        this.equivalentClassesAxiomsByClass = this.buildLazy(AxiomType.EQUIVALENT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS, OWLEquivalentClassesAxiom.class);
        this.disjointClassesAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS, OWLDisjointClassesAxiom.class);
        this.disjointUnionAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_UNION, InitVisitorFactory.CLASSCOLLECTIONS, OWLDisjointUnionAxiom.class);
        this.hasKeyAxiomsByClass = this.buildLazy(AxiomType.HAS_KEY, InitVisitorFactory.CLASSSUPERNAMED, OWLHasKeyAxiom.class);
        this.equivalentObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS, OWLEquivalentObjectPropertiesAxiom.class);
        this.disjointObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS, OWLDisjointObjectPropertiesAxiom.class);
        this.objectPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_DOMAIN, InitVisitorFactory.OPSUBNAMED, OWLObjectPropertyDomainAxiom.class);
        this.objectPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_RANGE, InitVisitorFactory.OPSUBNAMED, OWLObjectPropertyRangeAxiom.class);
        this.functionalObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLFunctionalObjectPropertyAxiom.class);
        this.inverseFunctionalPropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLInverseFunctionalObjectPropertyAxiom.class);
        this.symmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.SYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLSymmetricObjectPropertyAxiom.class);
        this.asymmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLAsymmetricObjectPropertyAxiom.class);
        this.reflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.REFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLReflexiveObjectPropertyAxiom.class);
        this.irreflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLIrreflexiveObjectPropertyAxiom.class);
        this.transitivePropertyAxiomsByProperty = this.buildLazy(AxiomType.TRANSITIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED, OWLTransitiveObjectPropertyAxiom.class);
        this.inversePropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS, OWLInverseObjectPropertiesAxiom.class);
        this.equivalentDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS, OWLEquivalentDataPropertiesAxiom.class);
        this.disjointDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS, OWLDisjointDataPropertiesAxiom.class);
        this.dataPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_DOMAIN, InitVisitorFactory.DPSUBNAMED, OWLDataPropertyDomainAxiom.class);
        this.dataPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_RANGE, InitVisitorFactory.DPSUBNAMED, OWLDataPropertyRangeAxiom.class);
        this.functionalDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED, OWLFunctionalDataPropertyAxiom.class);
        this.classAssertionAxiomsByIndividual = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLClassAssertionAxiom.class);
        this.objectPropertyAssertionsByIndividual = this.buildLazy(AxiomType.OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLObjectPropertyAssertionAxiom.class);
        this.dataPropertyAssertionsByIndividual = this.buildLazy(AxiomType.DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLDataPropertyAssertionAxiom.class);
        this.negativeObjectPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLNegativeObjectPropertyAssertionAxiom.class);
        this.negativeDataPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED, OWLNegativeDataPropertyAssertionAxiom.class);
        this.differentIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.DIFFERENT_INDIVIDUALS, InitVisitorFactory.ICOLLECTIONS, OWLDifferentIndividualsAxiom.class);
        this.sameIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.SAME_INDIVIDUAL, InitVisitorFactory.ICOLLECTIONS, OWLSameIndividualAxiom.class);
        this.axiomsForSerialization.forEach(this::addAxiom);
        this.axiomsForSerialization = null;
    }

    public boolean anyEntities(EntityType<?> type) {
        if (EntityType.CLASS.equals(type)) {
            return !this.owlClassReferences.isEmpty();
        }
        if (EntityType.DATA_PROPERTY.equals(type)) {
            return !this.owlDataPropertyReferences.isEmpty();
        }
        if (EntityType.OBJECT_PROPERTY.equals(type)) {
            return !this.owlObjectPropertyReferences.isEmpty();
        }
        if (EntityType.ANNOTATION_PROPERTY.equals(type)) {
            return !this.owlAnnotationPropertyReferences.isEmpty();
        }
        if (EntityType.DATATYPE.equals(type)) {
            return !this.owlDatatypeReferences.isEmpty();
        }
        if (EntityType.NAMED_INDIVIDUAL.equals(type)) {
            return !this.owlIndividualReferences.isEmpty();
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.axiomsForSerialization = OWLAPIStreamUtils.asList(this.axiomsByType.getAllValues());
        stream.defaultWriteObject();
    }

    public boolean containsClassInSignature(IRI i) {
        return this.owlClassReferences.containsReference(i);
    }

    public boolean containsObjectPropertyInSignature(IRI i) {
        return this.owlObjectPropertyReferences.containsReference(i);
    }

    public boolean containsDataPropertyInSignature(IRI i) {
        return this.owlDataPropertyReferences.containsReference(i);
    }

    public boolean containsAnnotationPropertyInSignature(IRI i) {
        return this.owlAnnotationPropertyReferences.containsReference(i);
    }

    public boolean containsIndividualInSignature(IRI i) {
        return this.owlIndividualReferences.containsReference(i);
    }

    public boolean containsDatatypeInSignature(IRI i) {
        return this.owlDatatypeReferences.containsReference(i);
    }

    public boolean containsClassInSignature(OWLClass i) {
        return this.owlClassReferences.containsReference(i);
    }

    public boolean containsObjectPropertyInSignature(OWLObjectProperty i) {
        return this.owlObjectPropertyReferences.containsReference(i);
    }

    public boolean containsDataPropertyInSignature(OWLDataProperty i) {
        return this.owlDataPropertyReferences.containsReference(i);
    }

    public boolean containsAnnotationPropertyInSignature(OWLAnnotationProperty i) {
        return this.owlAnnotationPropertyReferences.containsReference(i);
    }

    public boolean containsIndividualInSignature(OWLNamedIndividual i) {
        return this.owlIndividualReferences.containsReference(i);
    }

    public boolean containsDatatypeInSignature(OWLDatatype i) {
        return this.owlDatatypeReferences.containsReference(i);
    }

    <T extends OWLObject, A extends OWLAxiom> Optional<MapPointer<T, A>> get(Class<T> type, Class<A> axiom) {
        return this.get(type, axiom, Navigation.IN_SUB_POSITION);
    }

    <T extends OWLObject, A extends OWLAxiom> Optional<MapPointer<T, A>> get(Class<T> type, Class<A> axiom, Navigation position) {
        if (OWLEntity.class.isAssignableFrom(type) && axiom.equals(OWLDeclarationAxiom.class)) {
            return OWLAPIPreconditions.optional(this.declarationsByEntity);
        }
        if (type.equals(OWLClass.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlClassReferences);
        }
        if (type.equals(OWLObjectProperty.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlObjectPropertyReferences);
        }
        if (type.equals(OWLDataProperty.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlDataPropertyReferences);
        }
        if (type.equals(OWLNamedIndividual.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlIndividualReferences);
        }
        if (type.equals(OWLAnonymousIndividual.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlAnonymousIndividualReferences);
        }
        if (type.equals(OWLDatatype.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlDatatypeReferences);
        }
        if (type.equals(OWLAnnotationProperty.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlAnnotationPropertyReferences);
        }
        if (type.equals(OWLClassExpression.class)) {
            return OWLAPIPreconditions.optional(this.classAssertionAxiomsByClass);
        }
        if (type.equals(OWLObjectPropertyExpression.class)) {
            if (axiom.equals(OWLSubObjectPropertyOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return OWLAPIPreconditions.optional(this.objectSubPropertyAxiomsBySuperPosition);
                }
                return OWLAPIPreconditions.optional(this.objectSubPropertyAxiomsBySubPosition);
            }
            if (axiom.equals(OWLEquivalentObjectPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.equivalentObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDisjointObjectPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLObjectPropertyDomainAxiom.class)) {
                return OWLAPIPreconditions.optional(this.objectPropertyDomainAxiomsByProperty);
            }
            if (axiom.equals(OWLObjectPropertyRangeAxiom.class)) {
                return OWLAPIPreconditions.optional(this.objectPropertyRangeAxiomsByProperty);
            }
            if (axiom.equals(OWLFunctionalObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.functionalObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLInverseFunctionalObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.inverseFunctionalPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLSymmetricObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.symmetricPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLAsymmetricObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.asymmetricPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLReflexiveObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.reflexivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLIrreflexiveObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.irreflexivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLTransitiveObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.transitivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLInverseObjectPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.inversePropertyAxiomsByProperty);
            }
        }
        if (type.equals(OWLDataPropertyExpression.class)) {
            if (axiom.equals(OWLSubDataPropertyOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return OWLAPIPreconditions.optional(this.dataSubPropertyAxiomsBySuperPosition);
                }
                return OWLAPIPreconditions.optional(this.dataSubPropertyAxiomsBySubPosition);
            }
            if (axiom.equals(OWLEquivalentDataPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.equivalentDataPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDisjointDataPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointDataPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDataPropertyDomainAxiom.class)) {
                return OWLAPIPreconditions.optional(this.dataPropertyDomainAxiomsByProperty);
            }
            if (axiom.equals(OWLDataPropertyRangeAxiom.class)) {
                return OWLAPIPreconditions.optional(this.dataPropertyRangeAxiomsByProperty);
            }
            if (axiom.equals(OWLFunctionalDataPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.functionalDataPropertyAxiomsByProperty);
            }
        }
        if (type.equals(OWLAnnotationSubject.class) || type.equals(IRI.class)) {
            return OWLAPIPreconditions.optional(this.annotationAssertionAxiomsBySubject);
        }
        if (type.equals(OWLIndividual.class)) {
            if (axiom.equals(OWLClassAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.classAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLObjectPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.objectPropertyAssertionsByIndividual);
            }
            if (axiom.equals(OWLDataPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.dataPropertyAssertionsByIndividual);
            }
            if (axiom.equals(OWLNegativeObjectPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.negativeObjectPropertyAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLNegativeDataPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.negativeDataPropertyAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLDifferentIndividualsAxiom.class)) {
                return OWLAPIPreconditions.optional(this.differentIndividualsAxiomsByIndividual);
            }
            if (axiom.equals(OWLSameIndividualAxiom.class)) {
                return OWLAPIPreconditions.optional(this.sameIndividualsAxiomsByIndividual);
            }
        }
        if (type.equals(OWLClass.class)) {
            if (axiom.equals(OWLSubClassOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return OWLAPIPreconditions.optional(this.subClassAxiomsBySuperPosition);
                }
                return OWLAPIPreconditions.optional(this.subClassAxiomsBySubPosition);
            }
            if (axiom.equals(OWLClassAxiom.class)) {
                return OWLAPIPreconditions.optional(this.classAxiomsByClass);
            }
            if (axiom.equals(OWLEquivalentClassesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.equivalentClassesAxiomsByClass);
            }
            if (axiom.equals(OWLDisjointClassesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointClassesAxiomsByClass);
            }
            if (axiom.equals(OWLDisjointUnionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointUnionAxiomsByClass);
            }
            if (axiom.equals(OWLHasKeyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.hasKeyAxiomsByClass);
            }
        }
        return OWLAPIPreconditions.emptyOptional();
    }

    protected <K, V extends OWLAxiom> MapPointer<K, V> build(Class<V> valueWithness) {
        return this.build(null, null, valueWithness);
    }

    protected <K, V extends OWLAxiom> MapPointer<K, V> buildLazy(AxiomType<?> t, OWLAxiomVisitorEx<?> v, Class<V> valueWithness) {
        return new MapPointer(t, v, false, this, valueWithness);
    }

    protected ClassAxiomByClassPointer buildClassAxiomByClass() {
        return new ClassAxiomByClassPointer(null, null, false, this);
    }

    protected <K, V extends OWLAxiom> MapPointer<K, V> build(@Nullable AxiomType<?> t, @Nullable OWLAxiomVisitorEx<?> v, Class<V> valueWithness) {
        return new MapPointer(t, v, true, this, valueWithness);
    }

    public boolean addAxiom(final OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null");
        if (this.axiomsByType.put(axiom.getAxiomType(), axiom)) {
            axiom.accept((OWLAxiomVisitor)this.addChangeVisitor);
            AbstractCollector referenceAdder = new AbstractCollector(){

                public void visit(OWLClass ce) {
                    Internals.this.owlClassReferences.put(ce, axiom);
                }

                public void visit(OWLObjectProperty property) {
                    Internals.this.owlObjectPropertyReferences.put(property, axiom);
                }

                public void visit(OWLDataProperty property) {
                    Internals.this.owlDataPropertyReferences.put(property, axiom);
                }

                public void visit(OWLNamedIndividual individual) {
                    Internals.this.owlIndividualReferences.put(individual, axiom);
                }

                public void visit(OWLAnnotationProperty property) {
                    Internals.this.owlAnnotationPropertyReferences.put(property, axiom);
                }

                public void visit(OWLDatatype node) {
                    Internals.this.owlDatatypeReferences.put(node, axiom);
                }

                public void visit(OWLAnonymousIndividual individual) {
                    Internals.this.owlAnonymousIndividualReferences.put(individual, axiom);
                }
            };
            axiom.accept((OWLObjectVisitor)referenceAdder);
            return true;
        }
        return false;
    }

    public boolean removeAxiom(final OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null");
        if (this.axiomsByType.remove(axiom.getAxiomType(), axiom)) {
            axiom.accept((OWLAxiomVisitor)this.removeChangeVisitor);
            AbstractCollector referenceRemover = new AbstractCollector(){

                public void visit(OWLClass ce) {
                    Internals.this.owlClassReferences.remove(ce, axiom);
                }

                public void visit(OWLObjectProperty property) {
                    Internals.this.owlObjectPropertyReferences.remove(property, axiom);
                }

                public void visit(OWLDataProperty property) {
                    Internals.this.owlDataPropertyReferences.remove(property, axiom);
                }

                public void visit(OWLNamedIndividual individual) {
                    Internals.this.owlIndividualReferences.remove(individual, axiom);
                }

                public void visit(OWLAnnotationProperty property) {
                    Internals.this.owlAnnotationPropertyReferences.remove(property, axiom);
                }

                public void visit(OWLDatatype node) {
                    Internals.this.owlDatatypeReferences.remove(node, axiom);
                }

                public void visit(OWLAnonymousIndividual individual) {
                    Internals.this.owlAnonymousIndividualReferences.remove(individual, axiom);
                }
            };
            axiom.accept((OWLObjectVisitor)referenceRemover);
            return true;
        }
        return false;
    }

    public boolean isDeclared(OWLEntity e) {
        return this.declarationsByEntity.containsKey(e);
    }

    public boolean isEmpty() {
        return this.axiomsByType.isEmpty() && this.ontologyAnnotations.isEmpty();
    }

    public <K> Collection<? extends OWLAxiom> filterAxioms(OWLAxiomSearchFilter filter, K key) {
        Optional<MapPointer<OWLAnnotationSubject, OWLAnnotationAssertionAxiom>> mapPointerOptional;
        if (filter == Filters.annotations && (mapPointerOptional = this.get(OWLAnnotationSubject.class, OWLAnnotationAssertionAxiom.class)).isPresent()) {
            return mapPointerOptional.get().getValuesAsCollection((OWLAnnotationSubject)key);
        }
        return this.axiomsByType.filterAxioms(filter, key);
    }

    public <K> boolean contains(OWLAxiomSearchFilter filter, K key) {
        for (AxiomType at : filter.getAxiomTypes()) {
            if (!this.axiomsByType.matchOnValues(at, t -> filter.pass(t, key))) continue;
            return true;
        }
        return false;
    }

    public Stream<OWLImportsDeclaration> getImportsDeclarations() {
        return this.importsDeclarations.stream();
    }

    public boolean addImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        return this.importsDeclarations.add(importDeclaration);
    }

    public boolean removeImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        return this.importsDeclarations.remove(importDeclaration);
    }

    Stream<OWLAnnotation> getOntologyAnnotations() {
        return this.ontologyAnnotations.stream();
    }

    public boolean addOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.add(ann);
    }

    public boolean removeOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.remove(ann);
    }

    public int getAxiomCount() {
        return this.axiomsByType.size();
    }

    public Stream<OWLAxiom> getAxioms() {
        return this.axiomsByType.getAllValues();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        if (!this.axiomsByType.isInitialized()) {
            return 0;
        }
        return this.axiomsByType.countValues(axiomType);
    }

    public Stream<OWLLogicalAxiom> getLogicalAxioms() {
        return AxiomType.LOGICAL_AXIOM_TYPES.stream().map(type -> this.axiomsByType.values((AxiomType)type, OWLLogicalAxiom.class)).flatMap(x -> x);
    }

    public int getLogicalAxiomCount() {
        int count = 0;
        for (AxiomType type : AxiomType.LOGICAL_AXIOM_TYPES) {
            count += this.axiomsByType.countValues(type);
        }
        return count;
    }

    public Stream<OWLClassAxiom> getGeneralClassAxioms() {
        return this.generalClassAxioms.stream().sorted();
    }

    public boolean addGeneralClassAxioms(OWLClassAxiom ax) {
        return this.generalClassAxioms.add(ax);
    }

    public boolean removeGeneralClassAxioms(OWLClassAxiom ax) {
        return this.generalClassAxioms.remove(ax);
    }

    public boolean addPropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        return this.propertyChainSubPropertyAxioms.add(ax);
    }

    public boolean removePropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        return this.propertyChainSubPropertyAxioms.remove(ax);
    }

    public MapPointer<AxiomType, OWLAxiom> getAxiomsByType() {
        return this.axiomsByType;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Internals{(first 20 axioms) ");
        this.axiomsByType.getAllValues().limit(20L).forEach(a -> b.append(a).append('\n'));
        b.append('}');
        return b.toString();
    }

    public boolean containsReference(OWLEntity entity) {
        return (Boolean)entity.accept((OWLEntityVisitorEx)this.refChecker);
    }

    public Stream<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        return (Stream)owlEntity.accept((OWLEntityVisitorEx)this.refAxiomsCollector);
    }

    class AddAxiomVisitor
    implements OWLAxiomVisitor,
    Serializable {
        AddAxiomVisitor() {
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                Internals.this.subClassAxiomsBySubPosition.put(subClass, axiom);
                Internals.this.classAxiomsByClass.put(subClass, (OWLClassAxiom)axiom);
            } else {
                Internals.this.addGeneralClassAxioms((OWLClassAxiom)axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                Internals.this.subClassAxiomsBySuperPosition.put((OWLClass)axiom.getSuperClass(), axiom);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            Internals.this.negativeObjectPropertyAssertionAxiomsByIndividual.put(axiom.getSubject(), axiom);
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            Internals.this.asymmetricPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            Internals.this.reflexivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(d -> !d.isAnonymous()).forEach(desc -> {
                OWLClass cls = (OWLClass)desc;
                Internals.this.disjointClassesAxiomsByClass.put(cls, axiom);
                Internals.this.classAxiomsByClass.put(cls, (OWLClassAxiom)axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.addGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            Internals.this.dataPropertyDomainAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
                Internals.this.objectPropertyDomainAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentObjectPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)p, axiom));
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            Internals.this.inversePropertyAxiomsByProperty.put(axiom.getFirstProperty(), axiom);
            Internals.this.inversePropertyAxiomsByProperty.put(axiom.getSecondProperty(), axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            Internals.this.negativeDataPropertyAssertionAxiomsByIndividual.put(axiom.getSubject(), axiom);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            axiom.individuals().forEach(ind -> Internals.this.differentIndividualsAxiomsByIndividual.put((OWLIndividual)ind, axiom));
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointDataPropertyAxiomsByProperty.put((OWLDataPropertyExpression)p, axiom));
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointObjectPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)p, axiom));
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            Internals.this.objectPropertyRangeAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            Internals.this.objectPropertyAssertionsByIndividual.put(axiom.getSubject(), axiom);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            Internals.this.functionalObjectPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            Internals.this.objectSubPropertyAxiomsBySubPosition.put((OWLObjectPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.objectSubPropertyAxiomsBySuperPosition.put((OWLObjectPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            Internals.this.disjointUnionAxiomsByClass.put(axiom.getOWLClass(), axiom);
            Internals.this.classAxiomsByClass.put(axiom.getOWLClass(), (OWLClassAxiom)axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            Internals.this.declarationsByEntity.put(axiom.getEntity(), axiom);
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            Internals.this.annotationAssertionAxiomsBySubject.put((OWLAnnotationSubject)axiom.getSubject(), axiom);
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.hasKeyAxiomsByClass.put(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            Internals.this.symmetricPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            Internals.this.dataPropertyRangeAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            Internals.this.functionalDataPropertyAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentDataPropertyAxiomsByProperty.put((OWLDataPropertyExpression)p, axiom));
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            Internals.this.classAssertionAxiomsByIndividual.put(axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.classAssertionAxiomsByClass.put(axiom.getClassExpression(), axiom);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(d -> !d.isAnonymous()).forEach(desc -> {
                Internals.this.equivalentClassesAxiomsByClass.put((OWLClass)desc, axiom);
                Internals.this.classAxiomsByClass.put((OWLClass)desc, (OWLClassAxiom)axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.addGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            Internals.this.dataPropertyAssertionsByIndividual.put(axiom.getSubject(), axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            Internals.this.transitivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            Internals.this.irreflexivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            Internals.this.dataSubPropertyAxiomsBySubPosition.put((OWLDataPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.dataSubPropertyAxiomsBySuperPosition.put((OWLDataPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            Internals.this.inverseFunctionalPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            axiom.individuals().forEach(i -> Internals.this.sameIndividualsAxiomsByIndividual.put((OWLIndividual)i, axiom));
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            Internals.this.addPropertyChainSubPropertyAxioms(axiom);
        }
    }

    class RemoveAxiomVisitor
    implements OWLAxiomVisitor,
    Serializable {
        RemoveAxiomVisitor() {
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                Internals.this.subClassAxiomsBySubPosition.remove(subClass, axiom);
                Internals.this.classAxiomsByClass.remove(subClass, (OWLClassAxiom)axiom);
            } else {
                Internals.this.removeGeneralClassAxioms((OWLClassAxiom)axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                Internals.this.subClassAxiomsBySuperPosition.remove(axiom.getSuperClass().asOWLClass(), axiom);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            Internals.this.negativeObjectPropertyAssertionAxiomsByIndividual.remove(axiom.getSubject(), axiom);
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            Internals.this.asymmetricPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            Internals.this.reflexivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(c -> !c.isAnonymous()).map(AsOWLClass::asOWLClass).forEach(c -> {
                Internals.this.disjointClassesAxiomsByClass.remove((OWLClass)c, axiom);
                Internals.this.classAxiomsByClass.remove((OWLClass)c, (OWLClassAxiom)axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.removeGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            Internals.this.dataPropertyDomainAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
                Internals.this.objectPropertyDomainAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentObjectPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)p, axiom));
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            Internals.this.inversePropertyAxiomsByProperty.remove(axiom.getFirstProperty(), axiom);
            Internals.this.inversePropertyAxiomsByProperty.remove(axiom.getSecondProperty(), axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            Internals.this.negativeDataPropertyAssertionAxiomsByIndividual.remove(axiom.getSubject(), axiom);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            axiom.individuals().forEach(i -> Internals.this.differentIndividualsAxiomsByIndividual.remove((OWLIndividual)i, axiom));
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointDataPropertyAxiomsByProperty.remove((OWLDataPropertyExpression)p, axiom));
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointObjectPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)p, axiom));
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            Internals.this.objectPropertyRangeAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            Internals.this.objectPropertyAssertionsByIndividual.remove(axiom.getSubject(), axiom);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            Internals.this.functionalObjectPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            Internals.this.objectSubPropertyAxiomsBySubPosition.remove((OWLObjectPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.objectSubPropertyAxiomsBySuperPosition.remove((OWLObjectPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            Internals.this.disjointUnionAxiomsByClass.remove(axiom.getOWLClass(), axiom);
            Internals.this.classAxiomsByClass.remove(axiom.getOWLClass(), (OWLClassAxiom)axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            Internals.this.declarationsByEntity.remove(axiom.getEntity(), axiom);
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            Internals.this.annotationAssertionAxiomsBySubject.remove((OWLAnnotationSubject)axiom.getSubject(), axiom);
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.hasKeyAxiomsByClass.remove(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            Internals.this.symmetricPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            Internals.this.dataPropertyRangeAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            Internals.this.functionalDataPropertyAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentDataPropertyAxiomsByProperty.remove((OWLDataPropertyExpression)p, axiom));
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            Internals.this.classAssertionAxiomsByIndividual.remove(axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.classAssertionAxiomsByClass.remove(axiom.getClassExpression(), axiom);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(c -> !c.isAnonymous()).map(AsOWLClass::asOWLClass).forEach(c -> {
                Internals.this.equivalentClassesAxiomsByClass.remove((OWLClass)c, axiom);
                Internals.this.classAxiomsByClass.remove((OWLClass)c, (OWLClassAxiom)axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.removeGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            Internals.this.dataPropertyAssertionsByIndividual.remove(axiom.getSubject(), axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            Internals.this.transitivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            Internals.this.irreflexivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            Internals.this.dataSubPropertyAxiomsBySubPosition.remove((OWLDataPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.dataSubPropertyAxiomsBySuperPosition.remove((OWLDataPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            Internals.this.inverseFunctionalPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            axiom.individuals().forEach(i -> Internals.this.sameIndividualsAxiomsByIndividual.remove((OWLIndividual)i, axiom));
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            Internals.this.removePropertyChainSubPropertyAxioms(axiom);
        }
    }

    private class ReferenceChecker
    implements OWLEntityVisitorEx<Boolean>,
    Serializable {
        ReferenceChecker() {
        }

        public Boolean visit(OWLClass cls) {
            return Internals.this.owlClassReferences.containsKey(cls);
        }

        public Boolean visit(OWLObjectProperty property) {
            return Internals.this.owlObjectPropertyReferences.containsKey(property);
        }

        public Boolean visit(OWLDataProperty property) {
            return Internals.this.owlDataPropertyReferences.containsKey(property);
        }

        public Boolean visit(OWLNamedIndividual individual) {
            return Internals.this.owlIndividualReferences.containsKey(individual);
        }

        public Boolean visit(OWLDatatype datatype) {
            return Internals.this.owlDatatypeReferences.containsKey(datatype);
        }

        public Boolean visit(OWLAnnotationProperty property) {
            return Internals.this.owlAnnotationPropertyReferences.containsKey(property);
        }
    }

    private class ReferencedAxiomsCollector
    implements OWLEntityVisitorEx<Stream<OWLAxiom>>,
    Serializable {
        ReferencedAxiomsCollector() {
        }

        public Stream<OWLAxiom> visit(OWLClass cls) {
            return Internals.this.owlClassReferences.values(cls, OWLAxiom.class);
        }

        public Stream<OWLAxiom> visit(OWLObjectProperty property) {
            return Internals.this.owlObjectPropertyReferences.values(property, OWLAxiom.class);
        }

        public Stream<OWLAxiom> visit(OWLDataProperty property) {
            return Internals.this.owlDataPropertyReferences.values(property, OWLAxiom.class);
        }

        public Stream<OWLAxiom> visit(OWLNamedIndividual individual) {
            return Internals.this.owlIndividualReferences.values(individual, OWLAxiom.class);
        }

        public Stream<OWLAxiom> visit(OWLDatatype datatype) {
            return Internals.this.owlDatatypeReferences.values(datatype, OWLAxiom.class);
        }

        public Stream<OWLAxiom> visit(OWLAnnotationProperty property) {
            return Internals.this.owlAnnotationPropertyReferences.values(property, OWLAxiom.class);
        }
    }

    protected class SetPointer<K extends Serializable>
    implements Serializable {
        private final Set<K> set = CollectionFactory.createSyncSet();

        protected SetPointer() {
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public boolean add(K k) {
            return this.set.add(k);
        }

        public boolean remove(K k) {
            return this.set.remove(k);
        }

        public Stream<K> stream() {
            if (this.set.isEmpty()) {
                return Stream.empty();
            }
            ArrayList<K> toReturn = new ArrayList<K>(this.set);
            try {
                toReturn.sort(null);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Misbehaving triple comparator, leaving triples unsorted", (Throwable)e);
            }
            return toReturn.stream();
        }
    }
}

