/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.shacl.generator;

import com.ontotext.models.EnumValueDef;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.ShaclProperty;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.ShaclTargetNode;
import com.ontotext.models.ShaclType;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaConverter;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.ValueConversionException;
import com.ontotext.models.shacl.ConstraintContext;
import com.ontotext.models.shacl.Or;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.models.shacl.ShaclNode;
import com.ontotext.platform.shacl.generator.ShaclConverterOptions;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.ShaclBindException;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.util.Literals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SomlToShaclShapesConverter
implements SomlSchemaConverter<ShaclSchema> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SomlToShaclShapesConverter.class);
    private static final Set<LangFilter.TokenType> SPECIAL_TOKEN_TYPES = EnumSet.of(LangFilter.TokenType.NO_LANG, LangFilter.TokenType.UNIQUE, LangFilter.TokenType.ALL);
    private static final String LANG_TAG_INVENTED = "i";
    private static final String LANG_TAG_EXTENSION = "u";
    private final boolean enabled;
    private final ShaclConverterOptions converterOptions;
    Rdf4jInputValueConverter valueConverter = new Rdf4jInputValueConverter();

    public SomlToShaclShapesConverter() {
        this(false, new ShaclConverterOptions());
    }

    public SomlToShaclShapesConverter(boolean enabled) {
        this(enabled, new ShaclConverterOptions());
    }

    public SomlToShaclShapesConverter(boolean enabled, ShaclConverterOptions converterOptions) {
        this.enabled = enabled;
        this.converterOptions = converterOptions;
    }

    public ShaclSchema convert(SomlSchema soml) throws SomlConversionException {
        LOGGER.info("Converting SOML {} to SHACL", (Object)soml.getId());
        long startTime = System.currentTimeMillis();
        ShaclSchema shaclSchema = new ShaclSchema(soml.getId(), soml.getLabel());
        this.copyPrefixes(soml, shaclSchema);
        shaclSchema.setSpecialPrefixes(soml.getSpecialPrefixes());
        Shapes shapes = soml.getObjects();
        for (Shape shape : this.fetchValidatedShapes(shapes)) {
            String id = shape.getId();
            ShaclTargetNode targetNode = new ShaclTargetNode(shape, ShaclType.NODE_SHAPE, shaclSchema);
            targetNode.setShapeTypes(shapes.getHierarchy(id), shape.getConcreteSubTypes());
            this.addBaseNameProp(shape, targetNode);
            this.fetchValidatedProps(shape).forEach(prop -> {
                ShaclProperty property = new ShaclProperty(targetNode, prop);
                property.setPath(prop.getRdfProperty());
                this.generateConstraints((PropertyShape)prop, property);
            });
            shaclSchema.addShaclNode(targetNode);
        }
        shaclSchema.getShaclTargetNodes().forEach(node -> this.generateReferenceConstraints((ShaclTargetNode)node, shaclSchema));
        LOGGER.info("Successfully converted SOML to SHACL in {} ms", (Object)(System.currentTimeMillis() - startTime));
        LOGGER.debug("Outputting SHACL schema.");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(shaclSchema.toTurtle());
        }
        return shaclSchema;
    }

    private void generateReferenceConstraints(ShaclTargetNode node, ShaclSchema shaclSchema) {
        this.fetchValidatedProps(node.getTargetShape()).filter(PropertyShape::isObjectType).forEach(somlProp -> {
            ShaclProperty shaclProp = node.getProperty(somlProp.getName());
            shaclProp.addConstraint(ShaclConstraint.NODE, new ConstraintContext(Boolean.valueOf(false), (Object)ShaclConstraint.toShaclTargetReference((PropertyShape)somlProp, (ShaclSchema)shaclSchema)));
        });
    }

    private void copyPrefixes(SomlSchema soml, ShaclSchema shaclSchema) {
        Prefixes prefixes = new Prefixes();
        prefixes.putAll((Map)soml.getPrefixes());
        prefixes.expand(soml, soml.getSpecialPrefixes());
        prefixes.keySet().removeAll(this.converterOptions.getIgnoredPrefixes());
        shaclSchema.setPrefixes(prefixes);
    }

    private Stream<PropertyShape> fetchValidatedProps(Shape shape) {
        return shape.getProps().values().stream().filter(this::isShaclSupported);
    }

    private boolean isShaclSupported(Shape shape) {
        return !this.converterOptions.getIgnoredTypes().contains(shape.getId()) && !Shapes.SYSTEM_SHAPES.contains(shape.getId()) && shape.isMutable() && !shape.isIgnoredType();
    }

    private boolean isShaclSupported(PropertyShape propShape) {
        return propShape.getValidationIgnored() == false && propShape.isMutable() && (propShape.isScalarType() || this.isShaclSupported(propShape.getRangeShape()));
    }

    private void generateConstraints(PropertyShape prop, ShaclProperty shaclProp) {
        this.generateCardinalityConstraint(shaclProp, prop);
        this.generateValueInSetConstraints(shaclProp, prop);
        this.generateEnumValueInSetConstraints(shaclProp, prop);
        if (!prop.getRange().equals("iri")) {
            this.generateRangeConstraints(shaclProp, prop);
        }
        if (prop.getEquals() != null) {
            shaclProp.addConstraint(ShaclConstraint.EQUALS, new ConstraintContext(Boolean.valueOf(prop.isScalarType()), (Object)prop.getEquals()));
        }
        if (prop.isScalarType() && !prop.getScalarType().isEnum()) {
            if (prop.getRange().equals("string") || prop.getRange().equals("iri") || prop.getScalarType().isLangStringSupported()) {
                this.generateStringConstraints(shaclProp, prop);
            } else if (!prop.getRange().equals("boolean")) {
                this.generateNumberConstraints(shaclProp, prop);
            }
        }
    }

    private List<Shape> fetchValidatedShapes(Shapes shapes) {
        return shapes.values().stream().filter(this::isShaclSupported).collect(Collectors.toList());
    }

    private void addBaseNameProp(Shape shape, ShaclTargetNode targetNode) {
        if (null != shape.getName() && !shape.getAllProperties().containsKey((Object)shape.getName())) {
            ShaclProperty shaclName = new ShaclProperty(targetNode, null);
            shaclName.setPath(shape.getNameIri());
            shaclName.addConstraint(ShaclConstraint.MAX_COUNT, new ConstraintContext(Boolean.TRUE, (Object)1));
            shaclName.addConstraint(ShaclConstraint.MIN_COUNT, new ConstraintContext(Boolean.TRUE, (Object)1));
            shaclName.addConstraint(ShaclConstraint.DATATYPE, new ConstraintContext(Boolean.TRUE, (Object)"xsd:string"));
        }
    }

    private void generateNumberConstraints(ShaclProperty shaclProp, PropertyShape somlProp) {
        ConstraintContext context = new ConstraintContext(Boolean.valueOf(somlProp.isScalarType()), null);
        try {
            if (null != somlProp.getMinInclusive()) {
                context.setConstraintValue(this.valueConverter.convert(somlProp.getMinInclusive(), somlProp.getScalarType()));
                shaclProp.addConstraint(ShaclConstraint.MIN_INCLUSIVE, context);
            }
            if (null != somlProp.getMaxInclusive()) {
                context.setConstraintValue(this.valueConverter.convert(somlProp.getMaxInclusive(), somlProp.getScalarType()));
                shaclProp.addConstraint(ShaclConstraint.MAX_INCLUSIVE, context);
            }
            if (null != somlProp.getMinExclusive()) {
                context.setConstraintValue(this.valueConverter.convert(somlProp.getMinExclusive(), somlProp.getScalarType()));
                shaclProp.addConstraint(ShaclConstraint.MIN_EXCLUSIVE, context);
            }
            if (null != somlProp.getMaxExclusive()) {
                context.setConstraintValue(this.valueConverter.convert(somlProp.getMaxExclusive(), somlProp.getScalarType()));
                shaclProp.addConstraint(ShaclConstraint.MAX_EXCLUSIVE, context);
            }
        }
        catch (ValueConversionException vce) {
            throw new ShaclBindException(String.format("Property: %s defines illegal numerical constraint %s", somlProp.getName(), vce.getMessage()), ErrorCode.COULD_NOT_BIND_SHACL);
        }
    }

    private void generateStringConstraints(ShaclProperty shaclProp, PropertyShape somlProp) {
        Object pattern;
        boolean isScalar = somlProp.isScalarType();
        if (null != somlProp.getMinLength()) {
            shaclProp.addConstraint(ShaclConstraint.MIN_LENGTH, new ConstraintContext(Boolean.valueOf(isScalar), (Object)somlProp.getMinLength()));
        }
        if (null != somlProp.getMaxLength()) {
            shaclProp.addConstraint(ShaclConstraint.MAX_LENGTH, new ConstraintContext(Boolean.valueOf(isScalar), (Object)somlProp.getMaxLength()));
        }
        if ((pattern = somlProp.getPatternAndFlags()) instanceof String) {
            shaclProp.addConstraint(ShaclConstraint.PATTERN, new ConstraintContext(Boolean.valueOf(isScalar), pattern));
        } else if (pattern instanceof List && !((List)pattern).isEmpty()) {
            shaclProp.addConstraint(ShaclConstraint.PATTERN, new ConstraintContext(Boolean.valueOf(isScalar), ((List)pattern).get(0)));
            if (((List)pattern).size() == 2) {
                shaclProp.addConstraint(ShaclConstraint.FLAGS, new ConstraintContext(Boolean.valueOf(isScalar), ((List)pattern).get(1)));
            }
        }
        if (null != somlProp.getLangConfig() && null != somlProp.getLangConfig().getValidate() && somlProp.getScalarType().isLangStringSupported()) {
            this.generateLanguageConstraints(shaclProp, somlProp);
        }
    }

    private void generateLanguageConstraints(ShaclProperty shaclProp, PropertyShape somlProp) {
        List<LangFilter.Token> tokens = somlProp.getLangConfig().getValidator().getTokens().stream().filter(token -> {
            if (!(token instanceof LangFilter.TokenGroup)) {
                return !token.toString().contains("~");
            }
            return true;
        }).collect(Collectors.toList());
        tokens.forEach(token -> {
            if (token instanceof LangFilter.TokenGroup) {
                List subtokens = ((LangFilter.TokenGroup)token).getTokens();
                subtokens.removeIf(subtoken -> subtoken.toString().contains("~"));
            }
        });
        ArrayList<String> rdfTypes = new ArrayList<String>();
        if (!somlProp.getScalarType().isUnionType()) {
            rdfTypes.add(somlProp.getScalarType().getRdf());
        } else {
            somlProp.getScalarType().getUnionTypes().forEach(scalar -> rdfTypes.add(scalar.getRdf()));
        }
        rdfTypes.removeIf(scalar -> scalar.equals("rdf:langString"));
        boolean isUnique = tokens.stream().anyMatch(token -> token.getType() == LangFilter.TokenType.UNIQUE);
        if (isUnique) {
            shaclProp.addConstraint(ShaclConstraint.UNIQUE_LANG, new ConstraintContext(Boolean.valueOf(true), (Object)true));
            tokens.stream().filter(token -> token.getType() == LangFilter.TokenType.NO_LANG).findFirst().ifPresent(token -> rdfTypes.forEach(rdfType -> this.addQualifiedConstraint(shaclProp, (LangFilter.Token)token, (String)rdfType, ShaclConstraint.DATATYPE, true, false)));
        }
        tokens.stream().filter(token -> token.getType() == LangFilter.TokenType.ALL).map(LangFilter.TokenGroup.class::cast).flatMap(tokenGroup -> tokenGroup.getTokens().stream()).forEach(token -> this.addAllLangQualifiedShape(shaclProp, (LangFilter.Token)token, (List<String>)rdfTypes, isUnique));
        Function<LangFilter.Token, Stream> expandTokenGroups = token -> {
            if (token instanceof LangFilter.TokenGroup) {
                return ((LangFilter.TokenGroup)token).getTokens().stream();
            }
            return Stream.of(token);
        };
        List sanitizedLangs = tokens.stream().flatMap(expandTokenGroups).filter(token -> !SPECIAL_TOKEN_TYPES.contains(token.getType())).filter(LangFilter.Token::isInclusion).filter(token -> LangFilter.TokenType.EXACT_MATCH.equals((Object)token.getType())).map(token -> Literals.normalizeLanguageTag((String)token.getValue())).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (sanitizedLangs.isEmpty()) {
            return;
        }
        boolean emptyLanguage = tokens.stream().anyMatch(token -> token.getType() == LangFilter.TokenType.NO_LANG);
        if (!emptyLanguage && !somlProp.getScalarType().isUnionType()) {
            shaclProp.addConstraint(ShaclConstraint.LANG_IN, new ConstraintContext(Boolean.valueOf(true), sanitizedLangs));
        } else {
            ShaclNode langIn = (ShaclNode)ShaclConstraint.LANG_IN.getBuilder().apply(new ConstraintContext(Boolean.valueOf(true), sanitizedLangs));
            this.handleComplexLangInMatch(shaclProp, somlProp, langIn, rdfTypes);
        }
    }

    private void handleComplexLangInMatch(ShaclProperty shaclProp, PropertyShape somlProp, ShaclNode langIn, List<String> rdfTypes) {
        Or blankNodeLanguageIn = new Or(langIn);
        if (somlProp.isScalarType()) {
            rdfTypes.forEach(rdfType -> blankNodeLanguageIn.appendToNodes((ShaclNode)ShaclConstraint.DATATYPE.getBuilder().apply(new ConstraintContext(Boolean.valueOf(true), rdfType))));
        }
        shaclProp.getConstraints().add(blankNodeLanguageIn);
    }

    private void addAllLangQualifiedShape(ShaclProperty shaclProp, LangFilter.Token allLang, List<String> rdfTypes, boolean isUnique) {
        if (LangFilter.TokenType.NO_LANG.equals((Object)allLang.getType())) {
            rdfTypes.forEach(rdfType -> this.addQualifiedConstraint(shaclProp, allLang, (String)rdfType, ShaclConstraint.DATATYPE, isUnique, true));
        } else {
            String normalizedTag = StringUtils.strip((String)allLang.getValue(), (String)",-~;");
            if (!normalizedTag.equals(LANG_TAG_INVENTED) && !normalizedTag.equals(LANG_TAG_EXTENSION)) {
                normalizedTag = Literals.normalizeLanguageTag((String)normalizedTag);
            }
            this.addQualifiedConstraint(shaclProp, allLang, normalizedTag, ShaclConstraint.LANG_IN, isUnique, true);
        }
    }

    private void addQualifiedConstraint(ShaclProperty shaclProp, LangFilter.Token lang, String constraintValue, ShaclConstraint constraint, boolean isUnique, boolean isAll) {
        ShaclProperty propertyShape = new ShaclProperty(shaclProp.getContainedIn(), shaclProp.getTargetProp());
        propertyShape.setPath((String)shaclProp.getPath().getValue());
        propertyShape.addConstraint(ShaclConstraint.QUALIFIED_VALUE_SHAPE, new ConstraintContext(Boolean.valueOf(true), constraint.getBuilder().apply(new ConstraintContext(Boolean.valueOf(true), (Object)constraintValue))));
        if (lang.isExclusion()) {
            propertyShape.addConstraint(ShaclConstraint.QUALIFIED_MAX_COUNT, new ConstraintContext(Boolean.valueOf(true), (Object)0));
        } else {
            if (isAll) {
                propertyShape.addConstraint(ShaclConstraint.QUALIFIED_MIN_COUNT, new ConstraintContext(Boolean.valueOf(true), (Object)1));
            }
            if (isUnique && !constraint.equals((Object)ShaclConstraint.LANG_IN)) {
                propertyShape.addConstraint(ShaclConstraint.QUALIFIED_MAX_COUNT, new ConstraintContext(Boolean.valueOf(true), (Object)1));
            }
        }
    }

    private void generateCardinalityConstraint(ShaclProperty shaclProp, PropertyShape somlProp) {
        boolean isScalar = somlProp.isScalarType();
        if (somlProp.getMin() > 0) {
            shaclProp.addConstraint(ShaclConstraint.MIN_COUNT, new ConstraintContext(Boolean.valueOf(isScalar), (Object)somlProp.getMin()));
        }
        if (!somlProp.isMultivalued()) {
            shaclProp.addConstraint(ShaclConstraint.MAX_COUNT, new ConstraintContext(Boolean.valueOf(isScalar), (Object)1));
        } else if (!somlProp.getMax().equalsIgnoreCase("inf")) {
            shaclProp.addConstraint(ShaclConstraint.MAX_COUNT, new ConstraintContext(Boolean.valueOf(isScalar), (Object)Integer.valueOf(somlProp.getMax())));
        }
    }

    private void generateValueInSetConstraints(ShaclProperty shaclProp, PropertyShape somlProp) {
        if (CollectionsUtil.isNullOrEmpty((Collection)somlProp.getValuesIn()) || somlProp.isScalarType() && somlProp.getScalarType().isEnum()) {
            return;
        }
        Object valuesList = somlProp.getValuesIn();
        if (somlProp.isScalarType()) {
            valuesList = this.valueConverter.convert(valuesList, somlProp.getScalarType());
        } else {
            ScalarTypes scalarTypes = somlProp.getContainedIn().getContainedIn().getContainedIn().getContainedIn().getTypes();
            valuesList = this.valueConverter.convert(valuesList, (ScalarType)scalarTypes.get((Object)"iri"));
        }
        ConstraintContext context = new ConstraintContext(Boolean.valueOf(somlProp.isScalarType()), valuesList);
        if (Boolean.TRUE.equals(somlProp.isValuesListExclusive())) {
            shaclProp.addConstraint(ShaclConstraint.IN, context);
        } else {
            shaclProp.addConstraint(ShaclConstraint.HAS_VALUE_IN, context);
        }
    }

    private void generateEnumValueInSetConstraints(ShaclProperty shaclProp, PropertyShape somlProp) {
        if (somlProp.isScalarType() && somlProp.getScalarType().isEnum()) {
            Object valuesList = somlProp.getScalarType().getValues().stream().map(EnumValueDef::getName).collect(Collectors.toList());
            valuesList = this.valueConverter.convert(valuesList, somlProp.getScalarType());
            ConstraintContext context = new ConstraintContext(Boolean.valueOf(somlProp.isScalarType()), valuesList);
            shaclProp.addConstraint(ShaclConstraint.IN, context);
        }
    }

    private void generateRangeConstraints(ShaclProperty shaclProp, PropertyShape somlProp) {
        if (somlProp.isScalarType()) {
            if (!somlProp.getScalarType().isUnionType()) {
                shaclProp.addConstraint(ShaclConstraint.DATATYPE, new ConstraintContext(Boolean.valueOf(true), (Object)somlProp.getScalarType().getRdf()));
            } else {
                somlProp.getScalarType().getUnionTypes().forEach(scalarType -> shaclProp.addConstraint(ShaclConstraint.DATATYPE, new ConstraintContext(Boolean.valueOf(false), (Object)scalarType.getRdf())));
            }
        }
    }

    public String converSomlToShaclString(SomlSchema schema) throws SomlConversionException {
        return this.convert(schema).toTurtle();
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

