/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.JsonSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Iterator;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.hateoas.RepresentationModel;

public class HateoasLinksConverter
implements ModelConverter {
    private final ObjectMapperProvider springDocObjectMapper;

    public HateoasLinksConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public Schema<?> resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null && RepresentationModel.class.isAssignableFrom(javaType.getRawClass())) {
            Schema schema = chain.next().resolve(type, context, chain);
            String schemaName = schema.get$ref().substring("#/components/schemas/".length());
            Schema original = (Schema)context.getDefinedModels().get(schemaName);
            Object links = original.getProperties().get("_links");
            if (links instanceof JsonSchema) {
                JsonSchema jsonSchema = (JsonSchema)links;
                jsonSchema.set$ref("#/components/schemas/Links");
                jsonSchema.setType(null);
                jsonSchema.setItems(null);
                jsonSchema.setTypes(null);
            } else if (links instanceof ArraySchema) {
                ArraySchema arraySchema = (ArraySchema)links;
                arraySchema.set$ref("#/components/schemas/Links");
            }
            return schema;
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }
}

