/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.unfolding.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractIntensionalQueryMerger;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.query.unfolding.QueryUnfolder;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;

public class BasicQueryUnfolder
extends AbstractIntensionalQueryMerger
implements QueryUnfolder {
    private final Mapping mapping;
    private final SubstitutionFactory substitutionFactory;
    private final QueryTransformerFactory transformerFactory;
    private final AtomFactory atomFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final CoreUtilsFactory coreUtilsFactory;

    @AssistedInject
    private BasicQueryUnfolder(@Assisted Mapping mapping, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, QueryTransformerFactory transformerFactory, UnionBasedQueryMerger queryMerger, CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory) {
        super(iqFactory);
        this.mapping = mapping;
        this.substitutionFactory = substitutionFactory;
        this.transformerFactory = transformerFactory;
        this.queryMerger = queryMerger;
        this.coreUtilsFactory = coreUtilsFactory;
        this.atomFactory = atomFactory;
    }

    protected AbstractIntensionalQueryMerger.QueryMergingTransformer createTransformer(ImmutableSet<Variable> knownVariables) {
        return new BasicQueryUnfoldingTransformer(this.coreUtilsFactory.createVariableGenerator(knownVariables));
    }

    protected class BasicQueryUnfoldingTransformer
    extends AbstractIntensionalQueryMerger.QueryMergingTransformer {
        protected BasicQueryUnfoldingTransformer(VariableGenerator variableGenerator) {
            super(variableGenerator, BasicQueryUnfolder.this.iqFactory, BasicQueryUnfolder.this.substitutionFactory, BasicQueryUnfolder.this.atomFactory, BasicQueryUnfolder.this.transformerFactory);
        }

        protected Optional<IQ> getDefinition(IntensionalDataNode dataNode) {
            DataAtom atom = dataNode.getProjectionAtom();
            return Optional.of(atom).map(DataAtom::getPredicate).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).flatMap(p -> this.getDefinition((RDFAtomPredicate)p, (ImmutableList<? extends VariableOrGroundTerm>)atom.getArguments()));
        }

        private Optional<IQ> getDefinition(RDFAtomPredicate predicate, ImmutableList<? extends VariableOrGroundTerm> arguments) {
            return predicate.getPropertyIRI(arguments).map(i -> i.equals((Object)RDF.TYPE) ? this.getRDFClassDefinition(predicate, arguments) : BasicQueryUnfolder.this.mapping.getRDFPropertyDefinition(predicate, i)).orElseGet(() -> this.getStarDefinition(predicate));
        }

        private Optional<IQ> getRDFClassDefinition(RDFAtomPredicate predicate, ImmutableList<? extends VariableOrGroundTerm> arguments) {
            return predicate.getClassIRI(arguments).map(i -> BasicQueryUnfolder.this.mapping.getRDFClassDefinition(predicate, i)).orElseGet(() -> this.getStarClassDefinition(predicate));
        }

        private Optional<IQ> getStarClassDefinition(RDFAtomPredicate predicate) {
            return BasicQueryUnfolder.this.queryMerger.mergeDefinitions((Collection)BasicQueryUnfolder.this.mapping.getRDFClasses(predicate).stream().flatMap(i -> BasicQueryUnfolder.this.mapping.getRDFClassDefinition(predicate, i).stream()).collect(ImmutableCollectors.toList()));
        }

        private Optional<IQ> getStarDefinition(RDFAtomPredicate predicate) {
            return BasicQueryUnfolder.this.queryMerger.mergeDefinitions((Collection)BasicQueryUnfolder.this.mapping.getQueries(predicate));
        }

        protected IQTree handleIntensionalWithoutDefinition(IntensionalDataNode dataNode) {
            return this.iqFactory.createEmptyNode(dataNode.getVariables());
        }
    }
}

