/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.translation.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.query.translation.InsertClauseNormalizer;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Singleton
public class InsertClauseNormalizerImpl
implements InsertClauseNormalizer {
    private final CoreUtilsFactory coreUtilsFactory;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;
    private final FunctionSymbolFactory functionSymbolFactory;

    @Inject
    protected InsertClauseNormalizerImpl(CoreUtilsFactory coreUtilsFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory, FunctionSymbolFactory functionSymbolFactory) {
        this.coreUtilsFactory = coreUtilsFactory;
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.functionSymbolFactory = functionSymbolFactory;
    }

    @Override
    public InsertClauseNormalizer.Result normalize(ImmutableSet<IntensionalDataNode> dataNodes, IQTree whereTree) {
        ImmutableSet bNodes = (ImmutableSet)dataNodes.stream().map(IntensionalDataNode::getProjectionAtom).map(DataAtom::getArguments).flatMap(Collection::stream).filter(a -> a instanceof BNode).map(a -> (BNode)a).collect(ImmutableCollectors.toSet());
        if (bNodes.isEmpty()) {
            return new ResultImpl((ImmutableMap<BNode, Variable>)ImmutableMap.of());
        }
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)Sets.union((Set)whereTree.getKnownVariables(), (Set)((Set)dataNodes.stream().flatMap(n -> n.getKnownVariables().stream()).collect(ImmutableCollectors.toSet()))));
        ImmutableMap bNodeMap = (ImmutableMap)bNodes.stream().collect(ImmutableCollectors.toMap(b -> b, b -> variableGenerator.generateNewVariable()));
        VariableNullability variableNullability = whereTree.getVariableNullability();
        ImmutableSet nonNullableUniqueConstraints = (ImmutableSet)whereTree.inferUniqueConstraints().stream().filter(vs -> vs.stream().noneMatch(arg_0 -> ((VariableNullability)variableNullability).isPossiblyNullable(arg_0))).collect(ImmutableCollectors.toSet());
        ImmutableTerm term = nonNullableUniqueConstraints.isEmpty() ? this.createBNodeDefinitionsWithoutNonNullableUniqueConstraint((ImmutableSet<Variable>)whereTree.getVariables()) : this.createBNodeDefinitionsFromNonNullableUniqueConstraint((ImmutableSet<Variable>)((ImmutableSet)nonNullableUniqueConstraints.iterator().next()));
        Substitution substitution = (Substitution)bNodeMap.entrySet().stream().collect(this.substitutionFactory.toSubstitution(Map.Entry::getValue, e -> term));
        ImmutableSet newProjectedVariables = Sets.union((Set)whereTree.getKnownVariables(), (Set)ImmutableSet.copyOf((Collection)bNodeMap.values())).immutableCopy();
        return new ResultImpl((ImmutableMap<BNode, Variable>)bNodeMap, this.iqFactory.createConstructionNode(newProjectedVariables, substitution));
    }

    private ImmutableTerm createBNodeDefinitionsFromNonNullableUniqueConstraint(ImmutableSet<Variable> uniqueConstraint) {
        return this.generateBNodeTemplateFunctionalTerm(uniqueConstraint);
    }

    private ImmutableTerm createBNodeDefinitionsWithoutNonNullableUniqueConstraint(ImmutableSet<Variable> whereVariables) {
        if (whereVariables.isEmpty()) {
            return this.termFactory.getConstantBNode(UUID.randomUUID().toString());
        }
        return this.generateBNodeTemplateFunctionalTerm(whereVariables);
    }

    private ImmutableFunctionalTerm generateBNodeTemplateFunctionalTerm(ImmutableSet<Variable> variables) {
        if (variables.isEmpty()) {
            throw new RuntimeException("Was expecting at least one variable");
        }
        Template.Builder templateBuilder = Template.builder().string("rule-" + UUID.randomUUID()).placeholder();
        variables.stream().skip(1L).forEach(v -> templateBuilder.string("/").placeholder());
        ImmutableList arguments = (ImmutableList)variables.stream().map(v -> this.termFactory.getDBCoalesce((ImmutableTerm)this.termFactory.getImmutableFunctionalTerm(this.functionSymbolFactory.getExtractLexicalTermFromRDFTerm(), new ImmutableTerm[]{v}), (ImmutableTerm)this.termFactory.getDBStringConstant("null-value"), new ImmutableTerm[0])).collect(ImmutableCollectors.toList());
        return this.termFactory.getBnodeFunctionalTerm(templateBuilder.build(), arguments);
    }

    protected static class ResultImpl
    implements InsertClauseNormalizer.Result {
        private final @Nonnull ImmutableMap<BNode, Variable> map;
        private final @Nullable ConstructionNode constructionNode;

        protected ResultImpl(@Nonnull ImmutableMap<BNode, Variable> map, @Nullable ConstructionNode constructionNode) {
            this.constructionNode = constructionNode;
            this.map = map;
        }

        protected ResultImpl(@Nonnull ImmutableMap<BNode, Variable> map) {
            this.constructionNode = null;
            this.map = map;
        }

        @Override
        public ImmutableMap<BNode, Variable> getBNodeVariableMap() {
            return this.map;
        }

        @Override
        public Optional<ConstructionNode> getConstructionNode() {
            return Optional.ofNullable(this.constructionNode);
        }
    }
}

