/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.resultset.impl;

import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.query.resultset.OntopBinding;
import it.unibz.inf.ontop.query.resultset.OntopBindingSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractOntopBindingSet
implements OntopBindingSet {
    private final OntopBinding[] bindings;
    private @Nullable String uuid;

    AbstractOntopBindingSet(OntopBinding[] bindings) {
        this.bindings = bindings;
    }

    @Override
    public @Nonnull Iterator<OntopBinding> iterator() {
        return Arrays.stream(this.getBindings()).iterator();
    }

    @Override
    public OntopBinding[] getBindings() {
        return this.bindings;
    }

    @Override
    public String[] getBindingNames() {
        String[] bindingNames = new String[this.bindings.length];
        for (int i = 0; i < this.bindings.length; ++i) {
            bindingNames[i] = this.bindings[i].getName();
        }
        return bindingNames;
    }

    @Override
    public @Nullable RDFConstant getConstant(String name) {
        OntopBinding binding = this.getBinding(name);
        return binding == null ? null : binding.getValue();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.bindings[0].toString());
        for (int i = 1; i < this.bindings.length; ++i) {
            builder.append(this.bindings[i].toString()).append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.indexOf(bindingName) >= 0;
    }

    @Override
    public synchronized String getRowUUIDStr() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    @Override
    public @Nullable OntopBinding getBinding(String name) {
        int index = this.indexOf(name);
        if (index < 0) {
            return null;
        }
        return this.bindings[index];
    }

    private int indexOf(String bindingName) {
        for (int i = 0; i < this.bindings.length; ++i) {
            if (!this.bindings[i].getName().equals(bindingName)) continue;
            return i;
        }
        return -1;
    }
}

