/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatOption;
import com.azure.ai.openai.assistants.models.ToolDefinition;
import com.azure.ai.openai.assistants.models.UpdateToolResourcesOptions;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class UpdateAssistantOptions
implements JsonSerializable<UpdateAssistantOptions> {
    private String model;
    private String name;
    private String description;
    private String instructions;
    private List<ToolDefinition> tools;
    private Map<String, String> metadata;
    private UpdateToolResourcesOptions toolResources;
    private Double temperature;
    private Double topP;
    private BinaryData responseFormat;

    public String getModel() {
        return this.model;
    }

    public UpdateAssistantOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public UpdateAssistantOptions setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateAssistantOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public UpdateAssistantOptions setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public UpdateAssistantOptions setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public UpdateAssistantOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static UpdateAssistantOptions fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateAssistantOptions)jsonReader.readObject(reader -> {
            UpdateAssistantOptions deserializedUpdateAssistantOptions = new UpdateAssistantOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.model = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.description = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.instructions = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    List tools;
                    deserializedUpdateAssistantOptions.tools = tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.toolResources = UpdateToolResourcesOptions.fromJson(reader);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    deserializedUpdateAssistantOptions.responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedUpdateAssistantOptions.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateAssistantOptions;
        });
    }

    public UpdateToolResourcesOptions getToolResources() {
        return this.toolResources;
    }

    public UpdateAssistantOptions setToolResources(UpdateToolResourcesOptions toolResources) {
        this.toolResources = toolResources;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public UpdateAssistantOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public UpdateAssistantOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public AssistantsApiResponseFormatOption getResponseFormat() {
        return AssistantsApiResponseFormatOption.fromBinaryData(this.responseFormat);
    }

    public UpdateAssistantOptions setResponseFormat(AssistantsApiResponseFormatOption responseFormat) {
        this.responseFormat = responseFormat.getFormat() != null ? BinaryData.fromObject((Object)responseFormat.getFormat()) : (responseFormat.getMode() != null ? BinaryData.fromObject((Object)((Object)responseFormat.getMode())) : null);
        return this;
    }
}

