/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageAttachment;
import com.azure.ai.openai.assistants.models.MessageContent;
import com.azure.ai.openai.assistants.models.MessageIncompleteDetails;
import com.azure.ai.openai.assistants.models.MessageRole;
import com.azure.ai.openai.assistants.models.MessageStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

public final class ThreadMessage
implements JsonSerializable<ThreadMessage> {
    private final String id;
    private final String object = "thread.message";
    private final long createdAt;
    private final String threadId;
    private final MessageRole role;
    private final List<MessageContent> content;
    private final String assistantId;
    private final String runId;
    private final Map<String, String> metadata;
    private final MessageStatus status;
    private final MessageIncompleteDetails incompleteDetails;
    private final Long completedAt;
    private final Long incompleteAt;
    private final List<MessageAttachment> attachments;

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public String getThreadId() {
        return this.threadId;
    }

    public MessageRole getRole() {
        return this.role;
    }

    public List<MessageContent> getContent() {
        return this.content;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getRunId() {
        return this.runId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("thread_id", this.threadId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("incomplete_details", (JsonSerializable)this.incompleteDetails);
        jsonWriter.writeNumberField("completed_at", (Number)this.completedAt);
        jsonWriter.writeNumberField("incomplete_at", (Number)this.incompleteAt);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("run_id", this.runId);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ThreadMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ThreadMessage)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String threadId = null;
            MessageStatus status = null;
            MessageIncompleteDetails incompleteDetails = null;
            OffsetDateTime completedAt = null;
            OffsetDateTime incompleteAt = null;
            MessageRole role = null;
            List content = null;
            String assistantId = null;
            String runId = null;
            List attachments = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("thread_id".equals(fieldName)) {
                    threadId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = MessageStatus.fromString(reader.getString());
                    continue;
                }
                if ("incomplete_details".equals(fieldName)) {
                    incompleteDetails = MessageIncompleteDetails.fromJson(reader);
                    continue;
                }
                if ("completed_at".equals(fieldName)) {
                    Long completedAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (completedAtHolder == null) continue;
                    completedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(completedAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("incomplete_at".equals(fieldName)) {
                    Long incompleteAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (incompleteAtHolder == null) continue;
                    incompleteAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(incompleteAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = MessageRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> MessageContent.fromJson(reader1));
                    continue;
                }
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                    continue;
                }
                if ("run_id".equals(fieldName)) {
                    runId = reader.getString();
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    attachments = reader.readArray(reader1 -> MessageAttachment.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new ThreadMessage(id, createdAt, threadId, status, incompleteDetails, completedAt, incompleteAt, role, content, assistantId, runId, attachments, metadata);
        });
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public MessageIncompleteDetails getIncompleteDetails() {
        return this.incompleteDetails;
    }

    public OffsetDateTime getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.completedAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getIncompleteAt() {
        if (this.incompleteAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.incompleteAt), ZoneOffset.UTC);
    }

    public ThreadMessage(String id, OffsetDateTime createdAt, String threadId, MessageStatus status, MessageIncompleteDetails incompleteDetails, OffsetDateTime completedAt, OffsetDateTime incompleteAt, MessageRole role, List<MessageContent> content, String assistantId, String runId, List<MessageAttachment> attachments, Map<String, String> metadata) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.threadId = threadId;
        this.status = status;
        this.incompleteDetails = incompleteDetails;
        this.completedAt = completedAt == null ? null : Long.valueOf(completedAt.toEpochSecond());
        this.incompleteAt = incompleteAt == null ? null : Long.valueOf(incompleteAt.toEpochSecond());
        this.role = role;
        this.content = content;
        this.assistantId = assistantId;
        this.runId = runId;
        this.attachments = attachments;
        this.metadata = metadata;
    }

    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }
}

