/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.FileSearchToolCallResult;
import com.azure.ai.openai.assistants.models.RunStepToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RunStepFileSearchToolCall
extends RunStepToolCall {
    private String type = "file_search";
    private final List<FileSearchToolCallResult> fileSearch;

    @Override
    public String getType() {
        return this.type;
    }

    public List<FileSearchToolCallResult> getFileSearch() {
        return this.fileSearch;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("file_search", this.fileSearch, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepFileSearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepFileSearchToolCall)jsonReader.readObject(reader -> {
            String id = null;
            List fileSearch = null;
            String type = "file_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("file_search".equals(fieldName)) {
                    fileSearch = reader.readArray(reader1 -> FileSearchToolCallResult.fromJson(reader1));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepFileSearchToolCall deserializedRunStepFileSearchToolCall = new RunStepFileSearchToolCall(id, fileSearch);
            deserializedRunStepFileSearchToolCall.type = type;
            return deserializedRunStepFileSearchToolCall;
        });
    }

    private RunStepFileSearchToolCall(String id, List<FileSearchToolCallResult> fileSearch) {
        super(id);
        this.fileSearch = fileSearch;
    }
}

