/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.RunStepErrorCode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunStepError
implements JsonSerializable<RunStepError> {
    private final RunStepErrorCode code;
    private final String message;

    private RunStepError(RunStepErrorCode code, String message) {
        this.code = code;
        this.message = message;
    }

    public RunStepErrorCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code == null ? null : this.code.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static RunStepError fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepError)jsonReader.readObject(reader -> {
            RunStepErrorCode code = null;
            String message = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = RunStepErrorCode.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new RunStepError(code, message);
        });
    }
}

