/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.RequiredFunctionToolCallDetails;
import com.azure.ai.openai.assistants.models.RequiredToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RequiredFunctionToolCall
extends RequiredToolCall {
    private final RequiredFunctionToolCallDetails function;
    private String type = "function";

    public RequiredFunctionToolCallDetails getFunction() {
        return this.function;
    }

    private RequiredFunctionToolCall(String id, RequiredFunctionToolCallDetails function) {
        super(id);
        this.function = function;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeJsonField("function", (JsonSerializable)this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RequiredFunctionToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RequiredFunctionToolCall)jsonReader.readObject(reader -> {
            String id = null;
            RequiredFunctionToolCallDetails function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("function".equals(fieldName)) {
                    function = RequiredFunctionToolCallDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RequiredFunctionToolCall deserializedRequiredFunctionToolCall = new RequiredFunctionToolCall(id, function);
            deserializedRequiredFunctionToolCall.type = type;
            return deserializedRequiredFunctionToolCall;
        });
    }

    @Override
    public String getType() {
        return this.type;
    }
}

