/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageTextAnnotation;
import com.azure.ai.openai.assistants.models.MessageTextFilePathDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageTextFilePathAnnotation
extends MessageTextAnnotation {
    private final MessageTextFilePathDetails filePath;
    private String type = "file_path";
    private Integer startIndex;
    private Integer endIndex;

    public MessageTextFilePathDetails getFilePath() {
        return this.filePath;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.getText());
        jsonWriter.writeJsonField("file_path", (JsonSerializable)this.filePath);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        return jsonWriter.writeEndObject();
    }

    public static MessageTextFilePathAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return (MessageTextFilePathAnnotation)jsonReader.readObject(reader -> {
            String text = null;
            MessageTextFilePathDetails filePath = null;
            String type = "file_path";
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("file_path".equals(fieldName)) {
                    filePath = MessageTextFilePathDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            MessageTextFilePathAnnotation deserializedMessageTextFilePathAnnotation = new MessageTextFilePathAnnotation(text, filePath);
            deserializedMessageTextFilePathAnnotation.type = type;
            deserializedMessageTextFilePathAnnotation.startIndex = startIndex;
            deserializedMessageTextFilePathAnnotation.endIndex = endIndex;
            return deserializedMessageTextFilePathAnnotation;
        });
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageTextFilePathAnnotation(String text, MessageTextFilePathDetails filePath) {
        super(text);
        this.filePath = filePath;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public MessageTextFilePathAnnotation setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public MessageTextFilePathAnnotation setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
        return this;
    }
}

