/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageTextAnnotation;
import com.azure.ai.openai.assistants.models.MessageTextFileCitationDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageTextFileCitationAnnotation
extends MessageTextAnnotation {
    private final MessageTextFileCitationDetails fileCitation;
    private String type = "file_citation";
    private Integer startIndex;
    private Integer endIndex;

    public MessageTextFileCitationDetails getFileCitation() {
        return this.fileCitation;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.getText());
        jsonWriter.writeJsonField("file_citation", (JsonSerializable)this.fileCitation);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        return jsonWriter.writeEndObject();
    }

    public static MessageTextFileCitationAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return (MessageTextFileCitationAnnotation)jsonReader.readObject(reader -> {
            String text = null;
            MessageTextFileCitationDetails fileCitation = null;
            String type = "file_citation";
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("file_citation".equals(fieldName)) {
                    fileCitation = MessageTextFileCitationDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            MessageTextFileCitationAnnotation deserializedMessageTextFileCitationAnnotation = new MessageTextFileCitationAnnotation(text, fileCitation);
            deserializedMessageTextFileCitationAnnotation.type = type;
            deserializedMessageTextFileCitationAnnotation.startIndex = startIndex;
            deserializedMessageTextFileCitationAnnotation.endIndex = endIndex;
            return deserializedMessageTextFileCitationAnnotation;
        });
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageTextFileCitationAnnotation(String text, MessageTextFileCitationDetails fileCitation) {
        super(text);
        this.fileCitation = fileCitation;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public MessageTextFileCitationAnnotation setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public MessageTextFileCitationAnnotation setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
        return this;
    }
}

