/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageDeltaContent;
import com.azure.ai.openai.assistants.models.MessageDeltaTextContent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaTextContentObject
extends MessageDeltaContent {
    private String type = "text";
    private MessageDeltaTextContent text;

    private MessageDeltaTextContentObject(int index) {
        super(index);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaTextContent getText() {
        return this.text;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("text", (JsonSerializable)this.text);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaTextContentObject fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaTextContentObject)jsonReader.readObject(reader -> {
            int index = 0;
            String type = "text";
            MessageDeltaTextContent text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = MessageDeltaTextContent.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaTextContentObject deserializedMessageDeltaTextContentObject = new MessageDeltaTextContentObject(index);
            deserializedMessageDeltaTextContentObject.type = type;
            deserializedMessageDeltaTextContentObject.text = text;
            return deserializedMessageDeltaTextContentObject;
        });
    }
}

