/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageDeltaContent;
import com.azure.ai.openai.assistants.models.MessageDeltaImageFileContentObject;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaImageFileContent
extends MessageDeltaContent {
    private String type = "image_file";
    private MessageDeltaImageFileContentObject imageFile;

    private MessageDeltaImageFileContent(int index) {
        super(index);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaImageFileContentObject getImageFile() {
        return this.imageFile;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("image_file", (JsonSerializable)this.imageFile);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaImageFileContent fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaImageFileContent)jsonReader.readObject(reader -> {
            int index = 0;
            String type = "image_file";
            MessageDeltaImageFileContentObject imageFile = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("image_file".equals(fieldName)) {
                    imageFile = MessageDeltaImageFileContentObject.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaImageFileContent deserializedMessageDeltaImageFileContent = new MessageDeltaImageFileContent(index);
            deserializedMessageDeltaImageFileContent.type = type;
            deserializedMessageDeltaImageFileContent.imageFile = imageFile;
            return deserializedMessageDeltaImageFileContent;
        });
    }
}

