/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageDelta;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaChunk
implements JsonSerializable<MessageDeltaChunk> {
    private final String id;
    private final String object = "thread.message.delta";
    private final MessageDelta delta;

    private MessageDeltaChunk(String id, MessageDelta delta) {
        this.id = id;
        this.delta = delta;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public MessageDelta getDelta() {
        return this.delta;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeJsonField("delta", (JsonSerializable)this.delta);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaChunk fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaChunk)jsonReader.readObject(reader -> {
            String id = null;
            MessageDelta delta = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("delta".equals(fieldName)) {
                    delta = MessageDelta.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new MessageDeltaChunk(id, delta);
        });
    }
}

