/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MessageAttachment
implements JsonSerializable<MessageAttachment> {
    private final String fileId;
    private final List<BinaryData> tools;

    public MessageAttachment(String fileId, List<BinaryData> tools) {
        this.fileId = fileId;
        this.tools = tools;
    }

    public String getFileId() {
        return this.fileId;
    }

    public List<BinaryData> getTools() {
        return this.tools;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        return jsonWriter.writeEndObject();
    }

    public static MessageAttachment fromJson(JsonReader jsonReader) throws IOException {
        return (MessageAttachment)jsonReader.readObject(reader -> {
            String fileId = null;
            List tools = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                reader.skipChildren();
            }
            return new MessageAttachment(fileId, tools);
        });
    }
}

