/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.AssistantThreadCreationOptions;
import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatOption;
import com.azure.ai.openai.assistants.models.AssistantsApiToolChoiceOption;
import com.azure.ai.openai.assistants.models.ToolDefinition;
import com.azure.ai.openai.assistants.models.TruncationObject;
import com.azure.ai.openai.assistants.models.UpdateToolResourcesOptions;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateAndRunThreadOptions
implements JsonSerializable<CreateAndRunThreadOptions> {
    private final String assistantId;
    private AssistantThreadCreationOptions thread;
    private String model;
    private String instructions;
    private List<ToolDefinition> tools;
    private Map<String, String> metadata;
    private Boolean stream;
    private UpdateToolResourcesOptions toolResources;
    private Double temperature;
    private Double topP;
    private Integer maxPromptTokens;
    private Integer maxCompletionTokens;
    private TruncationObject truncationStrategy;
    private BinaryData toolChoice;
    private BinaryData responseFormat;
    private Boolean parallelToolCalls;

    public CreateAndRunThreadOptions(String assistantId) {
        this.assistantId = assistantId;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public AssistantThreadCreationOptions getThread() {
        return this.thread;
    }

    public CreateAndRunThreadOptions setThread(AssistantThreadCreationOptions thread) {
        this.thread = thread;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public CreateAndRunThreadOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public CreateAndRunThreadOptions setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public CreateAndRunThreadOptions setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateAndRunThreadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeJsonField("thread", (JsonSerializable)this.thread);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeNumberField("max_prompt_tokens", (Number)this.maxPromptTokens);
        jsonWriter.writeNumberField("max_completion_tokens", (Number)this.maxCompletionTokens);
        jsonWriter.writeJsonField("truncation_strategy", (JsonSerializable)this.truncationStrategy);
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CreateAndRunThreadOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CreateAndRunThreadOptions)jsonReader.readObject(reader -> {
            String assistantId = null;
            AssistantThreadCreationOptions thread = null;
            String model = null;
            String instructions = null;
            List tools = null;
            Boolean parallelToolCalls = null;
            UpdateToolResourcesOptions toolResources = null;
            Boolean stream = null;
            Double temperature = null;
            Double topP = null;
            Integer maxPromptTokens = null;
            Integer maxCompletionTokens = null;
            TruncationObject truncationStrategy = null;
            BinaryData toolChoice = null;
            BinaryData responseFormat = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                    continue;
                }
                if ("thread".equals(fieldName)) {
                    thread = AssistantThreadCreationOptions.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    toolResources = UpdateToolResourcesOptions.fromJson(reader);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max_prompt_tokens".equals(fieldName)) {
                    maxPromptTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("truncation_strategy".equals(fieldName)) {
                    truncationStrategy = TruncationObject.fromJson(reader);
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            CreateAndRunThreadOptions deserializedCreateAndRunThreadOptions = new CreateAndRunThreadOptions(assistantId);
            deserializedCreateAndRunThreadOptions.thread = thread;
            deserializedCreateAndRunThreadOptions.model = model;
            deserializedCreateAndRunThreadOptions.instructions = instructions;
            deserializedCreateAndRunThreadOptions.tools = tools;
            deserializedCreateAndRunThreadOptions.parallelToolCalls = parallelToolCalls;
            deserializedCreateAndRunThreadOptions.toolResources = toolResources;
            deserializedCreateAndRunThreadOptions.stream = stream;
            deserializedCreateAndRunThreadOptions.temperature = temperature;
            deserializedCreateAndRunThreadOptions.topP = topP;
            deserializedCreateAndRunThreadOptions.maxPromptTokens = maxPromptTokens;
            deserializedCreateAndRunThreadOptions.maxCompletionTokens = maxCompletionTokens;
            deserializedCreateAndRunThreadOptions.truncationStrategy = truncationStrategy;
            deserializedCreateAndRunThreadOptions.toolChoice = toolChoice;
            deserializedCreateAndRunThreadOptions.responseFormat = responseFormat;
            deserializedCreateAndRunThreadOptions.metadata = metadata;
            return deserializedCreateAndRunThreadOptions;
        });
    }

    Boolean isStream() {
        return this.stream;
    }

    CreateAndRunThreadOptions setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public UpdateToolResourcesOptions getToolResources() {
        return this.toolResources;
    }

    public CreateAndRunThreadOptions setToolResources(UpdateToolResourcesOptions toolResources) {
        this.toolResources = toolResources;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public CreateAndRunThreadOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public CreateAndRunThreadOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    public CreateAndRunThreadOptions setMaxPromptTokens(Integer maxPromptTokens) {
        this.maxPromptTokens = maxPromptTokens;
        return this;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public CreateAndRunThreadOptions setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    public TruncationObject getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public CreateAndRunThreadOptions setTruncationStrategy(TruncationObject truncationStrategy) {
        this.truncationStrategy = truncationStrategy;
        return this;
    }

    public AssistantsApiToolChoiceOption getToolChoice() {
        return AssistantsApiToolChoiceOption.fromBinaryData(this.toolChoice);
    }

    public CreateAndRunThreadOptions setToolChoice(AssistantsApiToolChoiceOption toolChoice) {
        this.toolChoice = toolChoice.getMode() != null ? BinaryData.fromObject((Object)((Object)toolChoice.getMode())) : (toolChoice.getToolChoice() != null ? BinaryData.fromObject((Object)toolChoice.getToolChoice()) : null);
        return this;
    }

    public AssistantsApiResponseFormatOption getResponseFormat() {
        return AssistantsApiResponseFormatOption.fromBinaryData(this.responseFormat);
    }

    public CreateAndRunThreadOptions setResponseFormat(AssistantsApiResponseFormatOption responseFormat) {
        this.responseFormat = responseFormat.getFormat() != null ? BinaryData.fromObject((Object)responseFormat.getFormat()) : (responseFormat.getMode() != null ? BinaryData.fromObject((Object)((Object)responseFormat.getMode())) : null);
        return this;
    }

    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public CreateAndRunThreadOptions setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }
}

