/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.ToolResources;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class AssistantThread
implements JsonSerializable<AssistantThread> {
    private final String id;
    private final String object = "thread";
    private final long createdAt;
    private final Map<String, String> metadata;
    private final ToolResources toolResources;

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AssistantThread fromJson(JsonReader jsonReader) throws IOException {
        return (AssistantThread)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            ToolResources toolResources = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    toolResources = ToolResources.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new AssistantThread(id, createdAt, toolResources, metadata);
        });
    }

    private AssistantThread(String id, OffsetDateTime createdAt, ToolResources toolResources, Map<String, String> metadata) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.toolResources = toolResources;
        this.metadata = metadata;
    }

    public ToolResources getToolResources() {
        return this.toolResources;
    }
}

