/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.implementation.models;

import com.azure.ai.openai.assistants.models.VectorStoreChunkingStrategyRequest;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CreateVectorStoreFileRequest
implements JsonSerializable<CreateVectorStoreFileRequest> {
    private final String fileId;
    private VectorStoreChunkingStrategyRequest chunkingStrategy;

    public CreateVectorStoreFileRequest(String fileId) {
        this.fileId = fileId;
    }

    public String getFileId() {
        return this.fileId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeJsonField("chunking_strategy", (JsonSerializable)this.chunkingStrategy);
        return jsonWriter.writeEndObject();
    }

    public static CreateVectorStoreFileRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateVectorStoreFileRequest)jsonReader.readObject(reader -> {
            String fileId = null;
            VectorStoreChunkingStrategyRequest chunkingStrategy = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                    continue;
                }
                if ("chunking_strategy".equals(fieldName)) {
                    chunkingStrategy = VectorStoreChunkingStrategyRequest.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            CreateVectorStoreFileRequest deserializedCreateVectorStoreFileRequest = new CreateVectorStoreFileRequest(fileId);
            deserializedCreateVectorStoreFileRequest.chunkingStrategy = chunkingStrategy;
            return deserializedCreateVectorStoreFileRequest;
        });
    }

    public VectorStoreChunkingStrategyRequest getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    public CreateVectorStoreFileRequest setChunkingStrategy(VectorStoreChunkingStrategyRequest chunkingStrategy) {
        this.chunkingStrategy = chunkingStrategy;
        return this;
    }
}

