/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.implementation;

import com.azure.ai.openai.assistants.AssistantsServiceVersion;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import java.util.Map;

public final class OpenAIUtils {
    private static final String OPEN_AI_ENDPOINT = "https://api.openai.com";

    private OpenAIUtils() {
    }

    public static String getOpenAIEndpoint() {
        return OPEN_AI_ENDPOINT;
    }

    public static boolean useAzureOpenAIService(String endpoint) {
        return endpoint != null && !endpoint.startsWith(OPEN_AI_ENDPOINT);
    }

    public static void addAzureVersionToRequestOptions(String endpoint, RequestOptions requestOptions, AssistantsServiceVersion serviceVersion) {
        if (OpenAIUtils.useAzureOpenAIService(endpoint)) {
            requestOptions.addQueryParam("api-version", serviceVersion.getVersion());
        }
    }

    public static BinaryData injectStreamJsonField(BinaryData inputJson, boolean stream) {
        Map mapJson = (Map)inputJson.toObject(Map.class);
        mapJson.put("stream", stream);
        inputJson = BinaryData.fromObject((Object)mapJson);
        return inputJson;
    }
}

