/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants;

import com.azure.ai.openai.assistants.AssistantsAsyncClient;
import com.azure.ai.openai.assistants.AssistantsClient;
import com.azure.ai.openai.assistants.AssistantsServiceVersion;
import com.azure.ai.openai.assistants.implementation.AssistantsClientImpl;
import com.azure.ai.openai.assistants.implementation.OpenAIUtils;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.KeyCredentialTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.KeyCredentialPolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={AssistantsClient.class, AssistantsAsyncClient.class})
public final class AssistantsClientBuilder
implements HttpTrait<AssistantsClientBuilder>,
ConfigurationTrait<AssistantsClientBuilder>,
TokenCredentialTrait<AssistantsClientBuilder>,
KeyCredentialTrait<AssistantsClientBuilder>,
EndpointTrait<AssistantsClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String[] DEFAULT_SCOPES = new String[]{"https://cognitiveservices.azure.com/.default"};
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-ai-openai-assistants.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private KeyCredential keyCredential;
    private String endpoint;
    private RetryPolicy retryPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(AssistantsClientBuilder.class);
    private AssistantsServiceVersion serviceVersion;

    public AssistantsClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.atInfo().log("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public AssistantsClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AssistantsClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public AssistantsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public AssistantsClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public AssistantsClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null.");
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public AssistantsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public AssistantsClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public AssistantsClientBuilder credential(KeyCredential keyCredential) {
        this.keyCredential = keyCredential;
        return this;
    }

    public AssistantsClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public AssistantsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpLogOptions localHttpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)localHttpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = new HttpHeaders();
        localClientOptions.getHeaders().forEach(header -> headers.set(HttpHeaderName.fromString((String)header.getName()), header.getValue()));
        if (!OpenAIUtils.useAzureOpenAIService(this.endpoint)) {
            headers.add("OpenAI-Beta", "assistants=v2");
        }
        if (headers.getSize() > 0) {
            policies.add(new AddHeadersPolicy(headers));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).forEach(p -> policies.add(p));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        if (this.keyCredential != null) {
            policies.add(OpenAIUtils.useAzureOpenAIService(this.endpoint) ? new KeyCredentialPolicy("api-key", this.keyCredential) : new KeyCredentialPolicy("Authorization", this.keyCredential, "Bearer"));
        }
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, DEFAULT_SCOPES));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).forEach(p -> policies.add(p));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(localHttpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).build();
        return httpPipeline;
    }

    public AssistantsAsyncClient buildAsyncClient() {
        return new AssistantsAsyncClient(this.buildInnerClient());
    }

    public AssistantsClient buildClient() {
        return new AssistantsClient(this.buildInnerClient());
    }

    public AssistantsClientBuilder serviceVersion(AssistantsServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    private AssistantsClientImpl buildInnerClient() {
        this.validateClient();
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        AssistantsServiceVersion localServiceVersion = this.serviceVersion != null ? this.serviceVersion : AssistantsServiceVersion.getLatest();
        AssistantsClientImpl client = new AssistantsClientImpl(localPipeline, JacksonAdapter.createDefaultSerializerAdapter(), OpenAIUtils.useAzureOpenAIService(this.endpoint) ? this.endpoint + (this.endpoint.endsWith("/") ? "openai" : "/openai") : OpenAIUtils.getOpenAIEndpoint() + "/v1", localServiceVersion);
        return client;
    }

    private void validateClient() {
    }
}

