/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface RdfTree {
    public static final String RES = "http://www.ontotext.com/semantic-object/result/";
    public static final String ERROR = "http://www.ontotext.com/semantic-object/result/ERROR";

    public int add(RdfPath var1);

    public RdfPath add(RdfPath var1, long var2, long var4);

    public RdfPath add(RdfPath var1, String var2, Object var3);

    default public int add(String subject, String predicate, Object object) {
        return this.add(this.getPool().toPath(subject, predicate, object));
    }

    public int addLiteral(long var1, long var3, long var5);

    default public boolean remove(String subject, String predicate, Object object) {
        return this.remove(this.getPool().toPath(subject, predicate, object));
    }

    public boolean remove(RdfPath var1);

    public void moveTo(RdfPath var1);

    public Collection<String> getResultIris(String var1);

    default public Collection<RdfPath> selectResults(String queryName) {
        return this.selectPaths(this.getPool().toPath(RES, queryName == null ? null : RES + queryName, null));
    }

    default public Collection<String> getQueries() {
        return this.select(this.getPool().toPath(RES, null, null)).stream().map(Triple::getPredicate).distinct().map(Object::toString).map(pred -> pred.replaceFirst(RES, "")).collect(Collectors.toList());
    }

    public Collection<Triple> getAllTriples();

    public void forEach(Consumer<Triple> var1);

    public void forEachPath(Consumer<RdfPath> var1);

    public Collection<Triple> select(RdfPath var1);

    public Collection<RdfPath> selectPaths(RdfPath var1);

    public Collection<Triple> findAtAnyDepth(String var1, String var2, Object var3);

    public Collection<LongTriple> findAtAnyDepth(long var1, long var3, long var5);

    public boolean contains(long var1, long var3, long var5);

    @Deprecated
    default public Stream<RdfPath> stream() {
        return this.preOrderStream();
    }

    public Stream<RdfPath> inOrderStream();

    public Stream<RdfPath> preOrderStream();

    public Collection<String> getPath(String ... var1);

    public boolean isEmpty();

    public void merge(RdfTree var1);

    public void setValueReader(ValueReader var1);

    public ValueReader getValueReader();

    public EntityPool getPool();
}

