/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.AbstractRdfData;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.FastRdfTree;
import com.ontotext.soaas.common.rdf.LongLongLongPredicate;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.RdfTree;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;

public class FastRdfData
extends AbstractRdfData
implements RdfData {
    private Long2ObjectMap<Long2ObjectMap<LongSet>> data = new Long2ObjectLinkedOpenHashMap();

    public FastRdfData() {
        this(EntityPoolFactory.fast());
    }

    public FastRdfData(EntityPool pool) {
        super(pool);
    }

    @Override
    public int add(long subject, long predicate, long object) {
        LongSet objects = (LongSet)((Long2ObjectMap)this.data.computeIfAbsent(subject, key -> this.createPredicatesCollection())).computeIfAbsent(predicate, key -> this.createValuesCollection());
        objects.add(object);
        return objects.size();
    }

    @Override
    public boolean remove(long subject, long predicate, long object) {
        LongSet objects = (LongSet)((Long2ObjectMap)this.data.computeIfAbsent(subject, key -> this.createPredicatesCollection())).computeIfAbsent(predicate, key -> this.createValuesCollection());
        if (objects.isEmpty()) {
            this.removeSubjectAndPredicateIfNeeded(subject, predicate);
            return false;
        }
        boolean removed = objects.remove(object);
        if (objects.isEmpty()) {
            this.removeSubjectAndPredicateIfNeeded(subject, predicate);
        }
        return removed;
    }

    private Long2ObjectLinkedOpenHashMap<LongSet> createPredicatesCollection() {
        return new Long2ObjectLinkedOpenHashMap(this.predicateCollectionSize);
    }

    private LongLinkedOpenHashSet createValuesCollection() {
        return new LongLinkedOpenHashSet(this.valueCollectionSize);
    }

    private void removeSubjectAndPredicateIfNeeded(long subject, long predicate) {
        Long2ObjectMap<LongSet> subjectMapping = this.get(subject);
        if (subjectMapping.isEmpty()) {
            this.data.remove(subject);
        } else {
            subjectMapping.remove(predicate);
            if (subjectMapping.isEmpty()) {
                this.data.remove(subject);
            }
        }
    }

    @Override
    public Map<String, Collection<Object>> get(String subject) {
        Long2ObjectMap predicateValues = (Long2ObjectMap)this.data.get(this.pool.resolve(subject));
        if (predicateValues == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Collection<Object>> result = new LinkedHashMap<String, Collection<Object>>(predicateValues.size());
        Long2ObjectMaps.fastForEach((Long2ObjectMap)predicateValues, entry -> result.put(this.pool.getString(entry.getLongKey()), this.convert((LongSet)entry.getValue())));
        return result;
    }

    @Override
    public Collection<Object> get(String subject, String predicate) {
        Long2ObjectMap predicateValues = (Long2ObjectMap)this.data.get(this.pool.resolve(subject));
        if (predicateValues == null) {
            return Collections.emptyList();
        }
        return this.convert((LongSet)predicateValues.get(this.pool.resolve(predicate)));
    }

    protected Long2ObjectMap<LongSet> get(long subject) {
        return (Long2ObjectMap)this.data.getOrDefault(subject, (Object)Long2ObjectMaps.emptyMap());
    }

    protected LongSet get(long subject, long predicate) {
        Long2ObjectMap predicateValues = (Long2ObjectMap)this.data.get(subject);
        if (predicateValues == null) {
            return LongSets.emptySet();
        }
        return (LongSet)predicateValues.getOrDefault(predicate, (Object)LongSets.emptySet());
    }

    private List<Object> convert(LongSet iterable) {
        if (iterable == null) {
            return new ArrayList<Object>(0);
        }
        int valuesCount = iterable.size();
        return iterable.longStream().mapToObj(this.pool::get).collect(Collectors.toCollection(() -> new ArrayList(valuesCount)));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public RdfTree toTree() {
        return new FastRdfTree(this);
    }

    @Override
    protected void filterByKnownPredicate(LongLongLongPredicate resultTriples, long subject, long predicate, long object) {
        LongSet objects = this.get(subject, predicate);
        if (object != 0L) {
            if (this.matchObjectValue(object, objects)) {
                resultTriples.test(subject, predicate, object);
            }
        } else if (objects != null) {
            this.appendValues(resultTriples, subject, predicate, objects);
        }
    }

    @Override
    protected void filterByAnyPredicate(LongLongLongPredicate resultTriples, long subject, long object) {
        if (object != 0L) {
            for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.get(subject))) {
                long pred = entry.getLongKey();
                if (!this.matchObjectValue(object, (LongSet)entry.getValue()) || resultTriples.test(subject, pred, object)) continue;
                return;
            }
        } else {
            for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.get(subject))) {
                long pred = entry.getLongKey();
                if (!this.appendValues(resultTriples, subject, pred, (LongSet)entry.getValue())) continue;
                return;
            }
        }
    }

    @Override
    protected void filterByObjectTest(LongLongLongPredicate resultTriples, LongPredicate objectTest) {
        for (Long2ObjectMap.Entry perSubject : Long2ObjectMaps.fastIterable(this.data)) {
            long subj = perSubject.getLongKey();
            for (Long2ObjectMap.Entry perPredicate : Long2ObjectMaps.fastIterable((Long2ObjectMap)((Long2ObjectMap)perSubject.getValue()))) {
                long value;
                long pred = perPredicate.getLongKey();
                LongIterator valuesIt = ((LongSet)perPredicate.getValue()).longIterator();
                while (valuesIt.hasNext() && objectTest.test(value = valuesIt.nextLong())) {
                    if (resultTriples.test(subj, pred, value)) continue;
                    return;
                }
            }
        }
    }

    @Override
    protected void filterByPredicate(LongLongLongPredicate resultTriples, long predicate, long object) {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.data)) {
            long subject = entry.getLongKey();
            LongSet values = (LongSet)((Long2ObjectMap)entry.getValue()).get(predicate);
            if (!(object != 0L ? this.matchObjectValue(object, values) && !resultTriples.test(subject, predicate, object) : this.appendValues(resultTriples, subject, predicate, values))) continue;
            return;
        }
    }

    private boolean appendValues(LongLongLongPredicate resultTriples, long subject, long predicate, LongSet values) {
        if (values == null) {
            return false;
        }
        LongIterator it = values.longIterator();
        while (it.hasNext()) {
            long value = it.nextLong();
            if (resultTriples.test(subject, predicate, value)) continue;
            return true;
        }
        return false;
    }

    private boolean matchObjectValue(long object, LongSet objects) {
        return objects != null && objects.contains(object);
    }
}

