/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.FastRdfData;
import com.ontotext.soaas.common.rdf.FastRdfTree;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class FastEntityPool
implements EntityPool {
    private final Long2ObjectMap<Object> longToObject;
    private final Object2LongMap<Object> objectToLong;
    private final int defaultPredicateCollectionSize;
    private final int defaultValueCollectionSize;
    private final AtomicLong counter;

    FastEntityPool(AtomicLong counter, int initialCapacity, int defaultPredicateCollectionSize, int defaultValueCollectionSize) {
        this.counter = counter;
        this.longToObject = new Long2ObjectOpenHashMap(initialCapacity);
        this.objectToLong = new Object2LongOpenHashMap(initialCapacity);
        this.defaultPredicateCollectionSize = defaultPredicateCollectionSize;
        this.defaultValueCollectionSize = defaultValueCollectionSize;
    }

    @Override
    public long resolve(Object value) {
        if (value == null) {
            return 0L;
        }
        return this.objectToLong.computeIfAbsent(value, anObject -> {
            long newId = this.counter.incrementAndGet();
            this.longToObject.put(newId, anObject);
            return newId;
        });
    }

    @Override
    public Object get(long id) {
        if (id == 0L) {
            return null;
        }
        return this.longToObject.get(id);
    }

    @Override
    public RdfPath toPath(String subject, String predicate, Object object) {
        return new RdfPath(this.resolve(subject), this.resolve(predicate), this.resolve(object), this);
    }

    @Override
    public RdfPath toPath(long subject, long predicate, long object) {
        return new RdfPath(subject, predicate, object, this);
    }

    @Override
    public LongTriple toTriple(String subject, String predicate, Object object) {
        return new LongTriple(this.resolve(subject), this.resolve(predicate), this.resolve(object), this);
    }

    @Override
    public int getDefaultValueCollectionSize() {
        return this.defaultValueCollectionSize;
    }

    @Override
    public int getDefaultPredicateCollectionSize() {
        return this.defaultPredicateCollectionSize;
    }

    @Override
    public RdfTree emptyTree() {
        return new FastRdfTree(this);
    }

    @Override
    public RdfData emptyData() {
        return new FastRdfData(this);
    }
}

