/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EclipseEntityPool;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.FastEntityPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class EntityPoolFactory {
    public static final int DEFAULT_SIZE = 512;
    private static final Supplier<EntityPool> DEFAULT_POOL_SUPPLIER = EntityPoolFactory::fast;
    private static Supplier<EntityPool> poolSupplier = DEFAULT_POOL_SUPPLIER;
    private static int defaultPredicateCollectionSize = 2;
    private static int defaultValueCollectionSize = 2;

    private EntityPoolFactory() {
    }

    public static EntityPool defaultPool() {
        return poolSupplier.get();
    }

    public static EntityPool eclipse() {
        return new EclipseEntityPool(new AtomicLong(), 512, defaultPredicateCollectionSize, defaultValueCollectionSize);
    }

    public static EntityPool fast() {
        return new FastEntityPool(new AtomicLong(), 512, defaultPredicateCollectionSize, defaultValueCollectionSize);
    }

    public static void setPoolSupplier(Supplier<EntityPool> poolSupplier) {
        EntityPoolFactory.poolSupplier = poolSupplier == null ? DEFAULT_POOL_SUPPLIER : poolSupplier;
    }

    public static int getDefaultPredicateCollectionSize() {
        return defaultPredicateCollectionSize;
    }

    public static void setDefaultPredicateCollectionSize(int defaultPredicateCollectionSize) {
        EntityPoolFactory.defaultPredicateCollectionSize = defaultPredicateCollectionSize;
    }

    public static int getDefaultValueCollectionSize() {
        return defaultValueCollectionSize;
    }

    public static void setDefaultValueCollectionSize(int defaultValueCollectionSize) {
        EntityPoolFactory.defaultValueCollectionSize = defaultValueCollectionSize;
    }
}

