/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EclipseRdfData;
import com.ontotext.soaas.common.rdf.EclipseRdfTree;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;

public class EclipseEntityPool
implements EntityPool {
    private final MutableLongObjectMap<Object> longToObject;
    private final MutableObjectLongMap<Object> objectToLong;
    private final int defaultPredicateCollectionSize;
    private final int defaultValueCollectionSize;
    private final AtomicLong counter;

    EclipseEntityPool(AtomicLong counter, int initialCapacity, int defaultPredicateCollectionSize, int defaultValueCollectionSize) {
        this.counter = counter;
        this.longToObject = LongObjectMaps.mutable.ofInitialCapacity(initialCapacity);
        this.objectToLong = ObjectLongMaps.mutable.ofInitialCapacity(initialCapacity);
        this.defaultPredicateCollectionSize = defaultPredicateCollectionSize;
        this.defaultValueCollectionSize = defaultValueCollectionSize;
    }

    @Override
    public long resolve(Object value) {
        if (value == null) {
            return 0L;
        }
        return this.objectToLong.getIfAbsentPutWithKey(value, (LongFunction & Serializable)anObject -> {
            long newId = this.counter.incrementAndGet();
            this.longToObject.put(newId, anObject);
            return newId;
        });
    }

    @Override
    public Object get(long id) {
        if (id == 0L) {
            return null;
        }
        return this.longToObject.get(id);
    }

    @Override
    public RdfPath toPath(String subject, String predicate, Object object) {
        return new RdfPath(this.resolve(subject), this.resolve(predicate), this.resolve(object), this);
    }

    @Override
    public RdfPath toPath(long subject, long predicate, long object) {
        return new RdfPath(subject, predicate, object, this);
    }

    @Override
    public LongTriple toTriple(String subject, String predicate, Object object) {
        return new LongTriple(this.resolve(subject), this.resolve(predicate), this.resolve(object), this);
    }

    @Override
    public int getDefaultPredicateCollectionSize() {
        return this.defaultPredicateCollectionSize;
    }

    @Override
    public int getDefaultValueCollectionSize() {
        return this.defaultValueCollectionSize;
    }

    @Override
    public RdfTree emptyTree() {
        return new EclipseRdfTree(this);
    }

    @Override
    public RdfData emptyData() {
        return new EclipseRdfData(this);
    }
}

