/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import java.io.Serializable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;

public class DistinctLongList
extends LongArrayList {
    private final transient MutableLongSet seenSoFar;

    public DistinctLongList() {
        this.seenSoFar = LongSets.mutable.empty();
    }

    public DistinctLongList(int initialCapacity) {
        super(initialCapacity);
        this.seenSoFar = LongSets.mutable.withInitialCapacity(initialCapacity);
    }

    public DistinctLongList(long ... array) {
        this(Math.max(8, array.length));
        this.addAll(array);
    }

    public boolean add(long newItem) {
        if (this.seenSoFar.add(newItem)) {
            return super.add(newItem);
        }
        return false;
    }

    public void clear() {
        this.seenSoFar.clear();
        super.clear();
    }

    public boolean contains(long value) {
        return this.seenSoFar.contains(value);
    }

    public boolean addAll(long ... source) {
        if (source.length < 1) {
            return false;
        }
        this.ensureCapacity(source.length);
        boolean added = false;
        for (long item : source) {
            added |= this.add(item);
        }
        return added;
    }

    public boolean addAll(LongIterable source) {
        return this.addAll(source.toArray());
    }

    public void addAtIndex(int index, long element) {
        if (this.seenSoFar.add(element)) {
            super.addAtIndex(index, element);
            return;
        }
        throw new IllegalStateException("Value " + element + " already present.");
    }

    public boolean addAllAtIndex(int index, long ... source) {
        throw new IllegalStateException("Method is addAllAtIndex not implemented");
    }

    public boolean addAllAtIndex(int index, LongIterable source) {
        throw new IllegalStateException("Method is addAllAtIndex not implemented");
    }

    public boolean remove(long value) {
        this.seenSoFar.remove(value);
        return super.remove(value);
    }

    public boolean removeIf(LongPredicate predicate) {
        return super.removeIf((LongPredicate & Serializable)value -> {
            if (predicate.test(value)) {
                this.seenSoFar.remove(value);
                return true;
            }
            return false;
        });
    }

    public boolean removeAll(long ... source) {
        this.seenSoFar.removeAll(source);
        return super.removeAll(source);
    }

    public boolean retainAll(LongIterable source) {
        this.seenSoFar.retainAll(source);
        return super.retainAll(source);
    }

    public boolean retainAll(long ... source) {
        this.seenSoFar.retainAll(source);
        return super.retainAll(source);
    }

    public long removeAtIndex(int index) {
        long previous = super.removeAtIndex(index);
        if (previous != 0L) {
            this.seenSoFar.remove(previous);
        }
        return previous;
    }

    public long set(int index, long element) {
        if (this.seenSoFar.add(element)) {
            long previous = super.set(index, element);
            this.seenSoFar.remove(previous);
            return previous;
        }
        throw new IllegalStateException("Value " + element + " already present.");
    }

    public MutableLongList distinct() {
        return this;
    }
}

