/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.exceptions;

import com.ontotext.soaas.common.ErrorCode;

public abstract class PlatformRuntimeException
extends RuntimeException {
    final String message;
    final ErrorCode errorCode;
    final int httpStatusCode;

    public PlatformRuntimeException(String message, ErrorCode errorCode) {
        super(String.format("Error code %d: %s", errorCode.getCode(), message));
        this.message = message;
        this.errorCode = errorCode;
        this.httpStatusCode = errorCode.getHttpCode();
    }

    public PlatformRuntimeException(String message, ErrorCode errorCode, int httpStatus) {
        super(String.format("Error code %d: %s", errorCode.getCode(), message));
        this.message = message;
        this.errorCode = errorCode;
        this.httpStatusCode = httpStatus;
    }

    public String getReason() {
        return this.message;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public int getHttpStatus() {
        return this.httpStatusCode;
    }
}

