/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.concurrent;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.concurrent.Node;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ExecutionTree() {
    }

    public static <N extends Node<N>, D, E extends ExecutionResponse<? extends D>, R> Executor<N, D, E, R> newExecutor(BiFunction<N, E, CompletableFuture<E>> workerFunction, BinaryOperator<D> dataReducer, BiFunction<D, Collection<Throwable>, R> resultBuilder) {
        return new Executor<N, D, E, R>(resultBuilder, dataReducer, workerFunction);
    }

    public static class Executor<N extends Node<N>, D, E extends ExecutionResponse<? extends D>, R> {
        private final BiFunction<D, Collection<Throwable>, R> resultBuilder;
        private final BinaryOperator<D> dataReducer;
        private final BiFunction<N, E, CompletableFuture<E>> workerFunction;

        private Executor(BiFunction<D, Collection<Throwable>, R> resultBuilder, BinaryOperator<D> dataReducer, BiFunction<N, E, CompletableFuture<E>> workerFunction) {
            this.resultBuilder = resultBuilder;
            this.dataReducer = dataReducer;
            this.workerFunction = workerFunction;
        }

        public CompletableFuture<R> invoke(Collection<N> nodes) {
            int expectedRequests = nodes.size();
            DataAccumulator accumulator = new DataAccumulator(this.resultBuilder, this.dataReducer, expectedRequests);
            nodes.stream().filter(Node::isRootNode).forEach(this.triggerInitialStepExecution(accumulator));
            return CompletableFuture.supplyAsync(accumulator::buildResult);
        }

        private Consumer<N> triggerInitialStepExecution(DataAccumulator<D, E, R> accumulator) {
            return subStep -> this.createInvocationTree(subStep, null, subStep.getNodes(), accumulator, true, 0);
        }

        private Consumer<E> runSubSteps(Collection<N> nextSteps, DataAccumulator accumulator, int order) {
            AtomicInteger orderVar = new AtomicInteger(order);
            return lastResponse -> nextSteps.forEach(this.triggerSubStepExecution(accumulator, lastResponse, orderVar.incrementAndGet()));
        }

        private Consumer<N> triggerSubStepExecution(DataAccumulator<D, E, R> accumulator, E lastResponse, int order) {
            AtomicInteger orderVar = new AtomicInteger(order);
            return subStep -> this.createInvocationTree(subStep, lastResponse, subStep.getNodes(), accumulator, false, orderVar.incrementAndGet());
        }

        private void createInvocationTree(N step, E previousResult, Collection<N> nextSteps, DataAccumulator<D, E, R> accumulator, boolean initialRequest, int order) {
            BiConsumer<E, Throwable> dataConsumerFunction = this.createAccumulationFunction(nextSteps, accumulator, initialRequest, order);
            CompletableFuture<E> completableFuture = this.workerFunction.apply(step, previousResult);
            CompletionStage subFuture = nextSteps.isEmpty() ? completableFuture.whenComplete((BiConsumer)dataConsumerFunction) : ((CompletableFuture)completableFuture.whenComplete((BiConsumer)dataConsumerFunction)).thenAccept(this.runSubSteps(nextSteps, accumulator, order + 1));
            accumulator.addFuture((CompletableFuture)subFuture);
        }

        private BiConsumer<E, Throwable> createAccumulationFunction(Collection<N> nextSteps, DataAccumulator<D, E, R> accumulator, boolean initialRequest, int order) {
            LOGGER.debug("Creating accumulation function for order {} initial: {}", (Object)order, (Object)initialRequest);
            int nextTreeCount = this.calculateTreeCount(nextSteps);
            BiConsumer<ExecutionResponse, Throwable> dataConsumerFunction = initialRequest ? (sparqlResponse, throwable) -> accumulator.initData((Object)sparqlResponse, (Throwable)throwable, nextTreeCount, order) : (sparqlResponse, throwable) -> accumulator.accumulate((Object)sparqlResponse, (Throwable)throwable, nextTreeCount, order);
            return dataConsumerFunction;
        }

        private int calculateTreeCount(Collection<N> nextSteps) {
            return nextSteps.stream().mapToInt(value -> {
                if (value.getNodes().isEmpty()) {
                    return 1;
                }
                return this.calculateTreeCount(value.getNodes());
            }).sum();
        }
    }

    private static class OrderedData<D>
    implements Comparable<OrderedData<D>> {
        private final int order;
        private final D data;

        OrderedData(int order, D data) {
            this.order = order;
            this.data = data;
        }

        public int getOrder() {
            return this.order;
        }

        public D getData() {
            return this.data;
        }

        @Override
        public int compareTo(OrderedData<D> other) {
            return Integer.compare(this.order, other.getOrder());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OrderedData)) {
                return false;
            }
            OrderedData that = (OrderedData)obj;
            return this.order == that.order;
        }

        public int hashCode() {
            return Objects.hash(this.order);
        }
    }

    private static class DataAccumulator<D, I extends ExecutionResponse<? extends D>, R> {
        private final Set<OrderedData<D>> rdfData = Collections.synchronizedSet(new TreeSet());
        private List<Throwable> errors;
        private final List<CompletableFuture> futures = new CopyOnWriteArrayList<CompletableFuture>();
        private final BiFunction<D, Collection<Throwable>, R> resultFunction;
        private final BinaryOperator<D> dataCombiner;
        private final CountDownLatch expectedFutures;

        DataAccumulator(BiFunction<D, Collection<Throwable>, R> resultFunction, BinaryOperator<D> dataCombiner, int expectedRequests) {
            this.resultFunction = resultFunction;
            this.dataCombiner = dataCombiner;
            this.expectedFutures = new CountDownLatch(expectedRequests);
        }

        void addFuture(CompletableFuture future) {
            this.futures.add(future);
            this.expectedFutures.countDown();
        }

        void initData(I executionResponse, Throwable throwable, int skippedCount, int order) {
            if (executionResponse != null) {
                this.accumulateData(executionResponse.getData(), order);
                if (executionResponse.getError() != null) {
                    this.accumulateError(executionResponse.getError());
                    this.forgetNFutures(skippedCount);
                }
            } else {
                this.accumulateError(throwable);
                this.forgetNFutures(skippedCount);
            }
        }

        private void forgetNFutures(int skippedCount) {
            for (int i = 0; i < skippedCount; ++i) {
                this.expectedFutures.countDown();
            }
        }

        void accumulate(I sparqlResponse, Throwable throwable, int skippedCount, int order) {
            if (sparqlResponse != null) {
                this.accumulateData(sparqlResponse.getData(), order);
                if (sparqlResponse.getError() != null) {
                    this.accumulateError(sparqlResponse.getError());
                    this.forgetNFutures(skippedCount);
                }
            } else {
                this.accumulateError(throwable);
                this.forgetNFutures(skippedCount);
            }
        }

        private void accumulateData(D newData, int order) {
            if (newData == null) {
                return;
            }
            this.rdfData.add(new OrderedData<D>(order, newData));
        }

        void accumulateError(Throwable error) {
            if (error == null) {
                return;
            }
            if (this.errors == null) {
                this.errors = new LinkedList<Throwable>();
            }
            LOGGER.trace("Accumulated execution error", error);
            this.errors.add(error);
        }

        R buildResult() {
            this.waitForAll();
            Optional<Object> endData = this.rdfData.stream().map(OrderedData::getData).reduce(this.dataCombiner);
            return (R)endData.map(data -> this.resultFunction.apply(data, this.errors)).orElseGet(() -> this.resultFunction.apply(null, this.errors));
        }

        private void waitForAll() {
            try {
                this.expectedFutures.await();
                CompletableFuture.allOf(this.futures.toArray(new CompletableFuture[0])).join();
            }
            catch (CompletionException ce) {
                this.accumulateError(ce.getCause());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.accumulateError(ie);
            }
        }
    }
}

