/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.concurrent;

public interface ExecutionResponse<R> {
    public static <R> ExecutionResponse<R> of(R data, String requestId) {
        return new SimpleExecutionResponse<R>(data, requestId, null);
    }

    public static <R> ExecutionResponse<R> ofError(String requestId, Throwable error) {
        return new SimpleExecutionResponse<Object>(null, requestId, error);
    }

    public String getRequestId();

    public R getData();

    public Throwable getError();

    default public boolean isSuccessful() {
        return this.getError() == null && this.getData() != null;
    }

    public static class SimpleExecutionResponse<R>
    implements ExecutionResponse<R> {
        private final R data;
        private final String requestId;
        private final Throwable error;

        SimpleExecutionResponse(R data, String requestId, Throwable error) {
            this.data = data;
            this.requestId = requestId;
            this.error = error;
        }

        @Override
        public String getRequestId() {
            return this.requestId;
        }

        @Override
        public R getData() {
            return this.data;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }
    }
}

