/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class CollectionsUtil {
    private static final Map<Class<? extends Collection>, Class<? extends Collection>> DEFAULT_COLLECTIONS = ImmutableMap.builder().put(Collection.class, ArrayList.class).put(List.class, ArrayList.class).put(Deque.class, LinkedList.class).put(Queue.class, LinkedList.class).put(Set.class, LinkedHashSet.class).build();
    private static final Class[] INT_ARG = new Class[]{Integer.TYPE};

    private CollectionsUtil() {
    }

    public static <K, V> Map<K, V> newMap(int size) {
        return new LinkedHashMap(size, 1.0f);
    }

    public static <E> boolean addIfNotNull(Collection<E> collection, E value) {
        if (value != null) {
            return collection.add(value);
        }
        return false;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotNullOrEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static void cleanDuplicates(Set<Object> setOne, Set<Object> setTwo) {
        LinkedHashSet<Object> toAddCopy = new LinkedHashSet<Object>(setOne);
        setOne.removeAll(setTwo);
        setTwo.removeAll(toAddCopy);
    }

    public static <T> BinaryOperator<T> throwIfSame() {
        return (first, second) -> {
            throw new IllegalStateException(String.format("Found elements with duplicate key: %s", first));
        };
    }

    public static Object putWithPath(Map<String, Object> target, String path, Object value) {
        Deque<String> stack = CollectionsUtil.parsePath(path);
        Map<String, Object> bottom = CollectionsUtil.traverse(target, stack);
        String tail = stack.pop();
        if (CollectionsUtil.isCollectionKey(tail)) {
            return CollectionsUtil.updateCollectionValue(value, bottom, tail);
        }
        return bottom.put(tail, value);
    }

    private static boolean isCollectionKey(String tail) {
        return tail.contains("[");
    }

    private static Object updateCollectionValue(Object newValue, Map<String, Object> bottom, String tail) {
        Pair<String, Integer> keyIndex = CollectionsUtil.splitKeyIndex(tail);
        String name = (String)keyIndex.getLeft();
        int idx = (Integer)keyIndex.getRight();
        Object currentValue = bottom.get(name);
        if (currentValue instanceof Collection) {
            Collection objects = (Collection)currentValue;
            if (((Collection)currentValue).size() >= idx + 1) {
                if (currentValue instanceof List) {
                    return ((List)currentValue).set(idx, newValue);
                }
                AtomicReference<Object> previousValue = new AtomicReference<Object>();
                Collection updatedCollection = objects.stream().map(CollectionsUtil.replaceByIndex(newValue, idx, previousValue)).collect(Collectors.toCollection(() -> CollectionsUtil.createNewCollection(currentValue.getClass(), objects.size())));
                bottom.put(name, updatedCollection);
                return previousValue.get();
            }
            objects.add(newValue);
            return null;
        }
        throw new IllegalArgumentException("Expected collection, found " + String.valueOf(currentValue != null ? currentValue.getClass() : null));
    }

    private static Function<Object, Object> replaceByIndex(Object newValue, int idx, AtomicReference<Object> previousValue) {
        AtomicInteger index = new AtomicInteger(0);
        return val -> {
            if (index.getAndIncrement() == idx) {
                previousValue.set(val);
                return newValue;
            }
            return val;
        };
    }

    public static Object getWithPath(Map<String, Object> target, String path) {
        Deque<String> stack = CollectionsUtil.parsePath(path);
        Map<String, Object> bottom = CollectionsUtil.traverse(target, stack);
        return CollectionsUtil.getNode(bottom, stack.pop());
    }

    private static Deque<String> parsePath(String path) {
        String[] pathNodes = path.split("\\.");
        LinkedList<String> stack = new LinkedList<String>();
        for (String pathNode : pathNodes) {
            stack.addLast(pathNode);
        }
        return stack;
    }

    private static Map<String, Object> traverse(Map<String, Object> current, Deque<String> nodes) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (nodes.size() == 1) {
            return current;
        }
        String head = nodes.pop();
        return CollectionsUtil.traverse((Map)CollectionsUtil.getNode(current, head), nodes);
    }

    private static Object getNode(Map<String, Object> current, String head) {
        if (CollectionsUtil.isCollectionKey(head)) {
            Pair<String, Integer> keyIndex = CollectionsUtil.splitKeyIndex(head);
            head = (String)keyIndex.getKey();
            int idx = (Integer)keyIndex.getRight();
            Object value = current.get(head);
            if (value instanceof List) {
                return ((List)value).get(idx);
            }
            if (value instanceof Collection) {
                return ((Collection)value).stream().skip(idx).findFirst().orElseThrow(() -> new IndexOutOfBoundsException("Index out of range: " + idx));
            }
        }
        return current.get(head);
    }

    private static Pair<String, Integer> splitKeyIndex(String pathNode) {
        String[] parts = pathNode.split("\\[", 2);
        String key = parts[0];
        String index = parts[1].substring(0, parts[1].length() - 1);
        int idx = Integer.parseInt(index);
        return Pair.of((Object)key, (Object)idx);
    }

    public static BiFunction<String, Object, Object> mergeValue(Object newValue) {
        return (key, oldValue) -> {
            if (oldValue == null || oldValue instanceof List && ((List)oldValue).isEmpty() || oldValue instanceof Map && ((Map)oldValue).isEmpty()) {
                return newValue;
            }
            if (newValue == null) {
                return oldValue;
            }
            if (oldValue instanceof Map && newValue instanceof Map) {
                ((Map)oldValue).putAll((Map)newValue);
                return oldValue;
            }
            if (oldValue instanceof List && newValue instanceof List) {
                CollectionsUtil.mergeLists((List)oldValue, (List)newValue);
                return oldValue;
            }
            throw new IllegalArgumentException("Only 2 maps or 2 lists could be merged together");
        };
    }

    private static void mergeLists(List<Map> oldList, List<Map> newList) {
        if (oldList.size() != newList.size()) {
            throw new IllegalArgumentException("Trying to merge 2 results with different size");
        }
        for (int i = 0; i < oldList.size(); ++i) {
            Map oldValues;
            Map newValues = newList.get(i);
            if (newValues == null || (oldValues = oldList.get(i)) == null) continue;
            oldValues.putAll(newValues);
        }
    }

    public static Collection<Object> createNewCollection(Class<? extends Collection<?>> collectionType, int size) {
        Class<Collection<Object>> concreteCollectionType = collectionType;
        if (concreteCollectionType.isInterface()) {
            concreteCollectionType = DEFAULT_COLLECTIONS.getOrDefault(collectionType, ArrayList.class);
        }
        try {
            Constructor<?>[] constructors = concreteCollectionType.getConstructors();
            Constructor<?> defaultConstructor = null;
            Constructor<?> sizedConstructor = null;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterCount() == 0) {
                    defaultConstructor = constructor;
                    continue;
                }
                if (constructor.getParameterCount() != 1 || !Arrays.equals(constructor.getParameterTypes(), INT_ARG)) continue;
                sizedConstructor = constructor;
            }
            if (sizedConstructor != null) {
                return (Collection)sizedConstructor.newInstance(size);
            }
            if (defaultConstructor != null) {
                return (Collection)defaultConstructor.newInstance(new Object[0]);
            }
            throw new IllegalArgumentException("The " + String.valueOf(concreteCollectionType) + " does not have a default constructor");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Cannot instantiate a collection of type " + String.valueOf(collectionType) + " with initial size!");
        }
    }

    public static <L, R, N> Function<Pair<L, R>, Pair<L, N>> foldRight(Function<R, N> fold) {
        return pair -> Pair.of((Object)pair.getLeft(), fold.apply(pair.getRight()));
    }

    public static <L, R, N> Function<Pair<L, R>, Pair<N, R>> foldLeft(Function<L, N> fold) {
        return pair -> Pair.of(fold.apply(pair.getLeft()), (Object)pair.getRight());
    }
}

