/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource.management;

import com.ontotext.forest.resource.management.ResourceAlreadyPresentException;
import com.ontotext.forest.resource.management.ResourceManagementService;
import com.ontotext.forest.resource.management.ResourceNotPresentException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/rest/resource"})
@Controller
public class ResourceManagementController {
    @Autowired
    private ResourceManagementService resourceManagementService;
    private Logger logger = LoggerFactory.getLogger(ResourceManagementController.class);

    @RequestMapping(method={RequestMethod.POST}, params={"uri"})
    public void createResource(@RequestParam(value="uri") IRI resource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.resourceManagementService.createResource((Resource)resource, (InputStream)request.getInputStream(), request.getHeader("Content-Type"));
            response.setStatus(201);
        }
        catch (Exception e) {
            this.handleError(e, response);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, params={"triple"})
    public void createResource(@RequestParam(value="triple") Triple resource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.resourceManagementService.createResource((Resource)resource, (InputStream)request.getInputStream(), request.getHeader("Content-Type"));
            response.setStatus(201);
        }
        catch (Exception e) {
            this.handleError(e, response);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, params={"uri"})
    public void updateResource(@RequestParam(value="uri") IRI resource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.resourceManagementService.updateResource((Resource)resource, (InputStream)request.getInputStream(), request.getHeader("Content-Type"));
            response.setStatus(204);
        }
        catch (Exception e) {
            this.handleError(e, response);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, params={"triple"})
    public void updateResource(@RequestParam(value="triple") Triple resource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.resourceManagementService.updateResource((Resource)resource, (InputStream)request.getInputStream(), request.getHeader("Content-Type"));
            response.setStatus(204);
        }
        catch (Exception e) {
            this.handleError(e, response);
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, params={"uri"})
    public void deleteResource(@RequestParam(value="uri") IRI resource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.resourceManagementService.deleteResource((Resource)resource);
            response.setStatus(204);
        }
        catch (Exception e) {
            this.handleError(e, response);
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, params={"triple"})
    public void deleteResource(@RequestParam(value="triple") Triple resource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.resourceManagementService.deleteResource((Resource)resource);
            response.setStatus(204);
        }
        catch (Exception e) {
            this.handleError(e, response);
        }
    }

    private void handleError(Exception e, HttpServletResponse response) throws Exception {
        if (e instanceof UnsupportedRDFormatException) {
            response.sendError(415, e.getMessage());
        } else if (e instanceof RDFParseException || e instanceof RDFHandlerException) {
            response.sendError(400, e.getMessage());
        } else if (e instanceof ResourceAlreadyPresentException || e instanceof ResourceNotPresentException) {
            response.sendError(409, e.getMessage());
        } else if (e instanceof RepositoryException) {
            response.sendError(500, e.getMessage());
        } else {
            throw e;
        }
        this.logger.error(e.getMessage(), (Throwable)e);
    }
}

