/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource.context;

import com.ontotext.forest.core.model.RdfTypedResource;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/rest/context"})
public class RestContextController {
    @Autowired
    private SemanticDataManagement dataManagement;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<RdfTypedResource>> listContexts(HttpServletRequest request, @RequestParam(defaultValue="0") Integer offset, @RequestParam(defaultValue="10") Integer size) {
        SemanticRepository repo = this.dataManagement.getCurrentRepository(request);
        return new ResponseEntity((Object)repo.getContexts(offset, size), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/size"}, method={RequestMethod.GET})
    public ResponseEntity<Integer> countContexts(HttpServletRequest request) {
        SemanticRepository repo = this.dataManagement.getCurrentRepository(request);
        return new ResponseEntity((Object)repo.getContexts().size(), (HttpStatusCode)HttpStatus.OK);
    }
}

