/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.web.WelcomePageResourceHttpRequestHandler;
import com.ontotext.forest.resource.explore.ExploreBean;
import com.ontotext.forest.resource.explore.ExploreService;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/resource/**"})
public class ResourceProviderController {
    @Autowired
    private ExploreService resourceService;
    @Autowired
    private SemanticDataManagement semanticDataManagement;
    @Autowired
    private WelcomePageResourceHttpRequestHandler welcomePageResourceHttpRequestHandler;

    @Hidden
    @RequestMapping(method={RequestMethod.GET}, produces={"!text/html"})
    public ResponseEntity<Model> resource(HttpServletRequest request) throws GraphDBWorkbenchException {
        String[] split;
        ExploreBean exploreBean = new ExploreBean();
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI iri = vf.createIRI(request.getRequestURL().toString());
        String all = "all";
        Model resourceGraph = this.resourceService.getResourceGraph(iri, "all", "all", true, exploreBean.getSameAs(), null, exploreBean.getLimit(), exploreBean.getOffset());
        if (resourceGraph.size() > 0) {
            return new ResponseEntity((Object)resourceGraph, (HttpStatusCode)HttpStatus.OK);
        }
        String pathMatch = request.getPathInfo().substring("/resource/".length());
        if (pathMatch.indexOf("/") > 0 && (split = pathMatch.split("/", 2)).length == 2) {
            String prefix = split[0];
            String localName = split[1];
            String namespace = this.semanticDataManagement.getCurrentRepositoryOrThrow().getNamespace(prefix);
            if (!StringUtils.isEmpty((CharSequence)namespace)) {
                IRI fullIRI = vf.createIRI(namespace, localName);
                return new ResponseEntity((Object)this.resourceService.getResourceGraph(fullIRI, "all", "all", exploreBean.getBnodes(), exploreBean.getSameAs(), null, exploreBean.getLimit(), exploreBean.getOffset()), (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)resourceGraph, (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @RequestMapping(method={RequestMethod.GET}, produces={"text/html"})
    public ResponseEntity<?> resourceNoAccept(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, GraphDBWorkbenchException {
        String accept = request.getHeader("Accept");
        if (accept == null || accept.startsWith("*/*")) {
            return this.resource(request);
        }
        this.welcomePageResourceHttpRequestHandler.handleRequest(request, response);
        return null;
    }
}

