/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.filter;

import com.ontotext.trree.plugin.externalsync.filter.Expression;
import com.ontotext.trree.plugin.externalsync.filter.FilterUtil;
import com.ontotext.trree.plugin.externalsync.filter.Operand;
import com.ontotext.trree.plugin.externalsync.filter.ValueIterator;
import com.ontotext.trree.plugin.externalsync.filter.ValueProvider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractFieldExpression
implements Expression {
    protected Operand operand;

    @Override
    public boolean evaluatePartial(int level, long value, long context, ValueProvider valueProvider, boolean agnosticValue) {
        boolean result;
        if (this.operand.partial) {
            if (this.operand.parentCount == level) {
                try (ValueIterator vit = FilterUtil.getOperandValuesSingleValue(this.operand, valueProvider, value, context);){
                    result = this.evaluate(valueProvider, vit);
                }
            } else {
                result = agnosticValue;
            }
        } else {
            result = this.evaluate(valueProvider);
        }
        return result;
    }

    @Override
    public boolean evaluate(ValueProvider valueProvider) {
        try (ValueIterator vit = FilterUtil.getOperandValues(this.operand, valueProvider);){
            boolean bl = this.evaluate(valueProvider, vit);
            return bl;
        }
    }

    protected abstract boolean evaluate(ValueProvider var1, ValueIterator var2);

    protected List<Operand> getOperands() {
        return Collections.singletonList(this.operand);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getOperands().stream().map(Objects::toString).collect(Collectors.joining("; ")) + "}";
    }
}

