/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync;

import com.ontotext.trree.plugin.externalsync.ControlPredicate;
import com.ontotext.trree.plugin.externalsync.iterators.master.AbstractResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.aggregations.AggregationResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.EntityResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.snippet.SnippetResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.facet.FacetResultIterator;
import com.ontotext.trree.sdk.QueryRequest;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Var;

public final class ExternalSyncRequestContext
implements RequestContext {
    private Request request;
    private List<MasterResultIterator> masters;
    private List<EntityResultIterator> entities;
    private List<FacetResultIterator> facets;
    private List<AggregationResultIterator> aggregationResults;
    private List<SnippetResultIterator> snippets;
    private boolean collectSnippets;
    private boolean trackTotalHits;
    private boolean trackScore;
    private String discoverySubject;
    private String discoveryObject;
    private ClassLoader pluginClassLoader;

    public ExternalSyncRequestContext(Request request, ClassLoader pluginClassLoader) {
        this.request = request;
        this.pluginClassLoader = pluginClassLoader;
    }

    private boolean tryToFindDiscoveryPattern(TupleExpr expr) {
        StatementPattern spatt;
        Var pvar;
        if (expr instanceof UnaryTupleOperator) {
            return this.tryToFindDiscoveryPattern(((UnaryTupleOperator)expr).getArg());
        }
        if (expr instanceof BinaryTupleOperator) {
            return this.tryToFindDiscoveryPattern(((BinaryTupleOperator)expr).getLeftArg()) || this.tryToFindDiscoveryPattern(((BinaryTupleOperator)expr).getLeftArg());
        }
        if (expr instanceof StatementPattern && (pvar = (spatt = (StatementPattern)expr).getPredicateVar()).isConstant() && ControlPredicate.DISCOVERY.getURISuffix().equals(pvar.getValue().stringValue())) {
            Var svar = spatt.getSubjectVar();
            Var ovar = spatt.getObjectVar();
            if (!svar.hasValue() && !ovar.hasValue()) {
                this.discoverySubject = svar.getName();
                this.discoveryObject = ovar.getName();
                return true;
            }
        }
        return false;
    }

    public void detectDiscoveryPattern() {
        if (this.discoverySubject != null) {
            return;
        }
        if (this.request instanceof QueryRequest) {
            QueryRequest qreq = (QueryRequest)this.request;
            QueryRoot qroot = (QueryRoot)qreq.getTupleExpr();
            this.tryToFindDiscoveryPattern((TupleExpr)qroot);
        }
    }

    public boolean hasDiscoveryPattern() {
        return this.discoverySubject != null;
    }

    public String getDiscoverySubject() {
        return this.discoverySubject;
    }

    public String getDiscoveryObject() {
        return this.discoveryObject;
    }

    public void registerIterator(AbstractResultIterator it) {
        if (it instanceof EntityResultIterator) {
            this.entities = ExternalSyncRequestContext.createIteratorList(this.entities);
            this.entities.add((EntityResultIterator)it);
        } else if (it instanceof FacetResultIterator) {
            this.facets = ExternalSyncRequestContext.createIteratorList(this.facets);
            this.facets.add((FacetResultIterator)it);
        } else if (it instanceof SnippetResultIterator) {
            this.snippets = ExternalSyncRequestContext.createIteratorList(this.snippets);
            this.snippets.add((SnippetResultIterator)it);
        } else if (it instanceof AggregationResultIterator) {
            this.aggregationResults = ExternalSyncRequestContext.createIteratorList(this.aggregationResults);
            this.aggregationResults.add((AggregationResultIterator)it);
        }
    }

    public void unregisterIterator(AbstractResultIterator it) {
        if (it instanceof EntityResultIterator && this.entities != null) {
            this.entities.remove((Object)it);
        } else if (it instanceof FacetResultIterator && this.facets != null) {
            this.facets.remove((Object)it);
        } else if (it instanceof SnippetResultIterator && this.snippets != null) {
            this.snippets.remove((Object)it);
        } else if (it instanceof AggregationResultIterator && this.aggregationResults != null) {
            this.aggregationResults.remove((Object)it);
        }
    }

    public void registerIterator(MasterResultIterator it) {
        this.masters = ExternalSyncRequestContext.createIteratorList(this.masters);
        this.masters.add(it);
    }

    public void unregisterIterator(MasterResultIterator it) {
        this.masters.remove((Object)it);
    }

    public MasterResultIterator findMasterIterator(long subject) {
        return ExternalSyncRequestContext.findIteratorBySubject(this.masters, subject);
    }

    public EntityResultIterator findEntityResultIterator(long id) {
        return ExternalSyncRequestContext.findIteratorByObject(this.entities, id);
    }

    public FacetResultIterator findFacetResultIterator(long object) {
        return ExternalSyncRequestContext.findIteratorByObject(this.facets, object);
    }

    public AggregationResultIterator findAggregationResultIterator(long object) {
        return ExternalSyncRequestContext.findIteratorByObject(this.aggregationResults, object);
    }

    public SnippetResultIterator findSnippetResultIterator(long object) {
        return ExternalSyncRequestContext.findIteratorByObject(this.snippets, object);
    }

    private static <T extends StatementIterator> List<T> createIteratorList(@Nullable List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        return list;
    }

    private static <T extends StatementIterator> T findIteratorBySubject(@Nullable List<T> list, long subject) {
        if (list == null) {
            return null;
        }
        for (StatementIterator it : list) {
            if (it.subject != subject) continue;
            return (T)it;
        }
        return null;
    }

    private static <T extends StatementIterator> T findIteratorByObject(@Nullable List<T> list, long object) {
        if (list == null) {
            return null;
        }
        for (StatementIterator it : list) {
            if (it.object != object) continue;
            return (T)it;
        }
        return null;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setCollectSnippets(boolean collectSnippets) {
        this.collectSnippets = collectSnippets;
    }

    public boolean isCollectSnippets() {
        return this.collectSnippets;
    }

    public void setTrackTotalHits(boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
    }

    public boolean isTrackTotalHits() {
        return this.trackTotalHits;
    }

    public void setTrackScore(boolean trackScore) {
        this.trackScore = trackScore;
    }

    public boolean isTrackScore() {
        return this.trackScore;
    }

    public void reset() {
        this.masters = null;
        this.entities = null;
        this.facets = null;
        this.aggregationResults = null;
        this.snippets = null;
        this.collectSnippets = false;
        this.trackTotalHits = false;
        this.trackScore = false;
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }
}

